import { tools } from 'amos-jsplumb';
import { stagePosition,typeValue } from './modelConf/stageConf';

export const commonAddNode = ({ eleType, labelValue, position,ruleNodeId }) => {
  return {
    config: {
      label: labelValue,
      nodeType: eleType,
      type:typeValue(eleType),
      ruleNodeId,
      style: {
        ...position
      }
    },
    id: tools.uuid()
  };
};


export const commonAddNodeAndConn = ({ eleType, labelValue, position, sourceId }) => {
  const targetId = tools.uuid();
  return {
    node: {
      config: {
        label: labelValue,
        nodeType: eleType,
        type:typeValue(eleType),
        style: {
          ...position
        }
      },
      id: targetId
    },
    conn: {
      sourceId,
      targetId
    }
  };
};

/**
 * 添加触发器、同时创建状态与触发器之间的连线
 * @param {object} param0
 */
export const addTrigerEleAndConn = ({ labelValue, position, statusId }) => {
  const targetId = tools.uuid();
  return {
    node: {
      config: {
        label: labelValue,
        type: 'trigger',
        nodeType:'trigger',
        style: {
          ...position
        }
      },
      id: targetId
    },
    conn: {
      sourceId: statusId,
      targetId
    }
  };
};

export const addTrigerAndAction = ({ labelValue, position, statusId }) => {
  const trigerId = tools.uuid();
  const actionId = tools.uuid();
  const actionPos = {
    left: position.left + (stagePosition.spaceX * stagePosition.ratio_3),
    top: position.top
  };

  return {
    node: [
      // trigger
      {
        id: trigerId,
        config: {
          label: labelValue,
          nodeType: 'trigger',
          type:'both',
          style: {
            ...position
          }
        }
      },
      // flowAction
      {
        id: actionId,
        config: {
          label: '动作',
          nodeType: 'flowAction',
          type:'both',
          style: {
            ...actionPos
          }
        }
      }
    ],
    conn: [{ sourceId: statusId, targetId: trigerId }, { sourceId: trigerId, targetId: actionId }]
  };
};

export const getEleNode = (target) => {
  if (target){
    const cls = target.className || '';
    if (cls.indexOf('ele') > -1){
      return target;
    }
    else {
      return getEleNode(target.parentNode);
    }
  }
};
