import { PlumbEleNode } from 'amos-jsplumb';

import Device from './datanode/Device';
import CurrentUser from './datanode/CurrentUser';
import SubUser from './datanode/SubUser';
import DatanodeTask from './datanode/Task';
import DatanodeView from './datanode/View';

import AlarmAll from './alarmnode/AlarmAll';
import AlarmQuota from './alarmnode/AlarmQuota';
import AlarmCollect from './alarmnode/AlarmCollect';
import AlarmDeviceOffline from './alarmnode/AlarmDeviceOffline';

import OutputEmail from './output/OutputEmail';
import OutputMqtt from './output/OutputMqtt';
import OutputTcp from './output/OutputTcp';

const { DefaultNode } = PlumbEleNode;

const typeToComponentMap = {
  custom: DefaultNode,
  datanodeDevice: Device,
  datanodeCurrentUser: CurrentUser,
  datanodeSubUser: SubUser,
  datanodeTask: DatanodeTask,
  datanodeView: DatanodeView,

  alarmAll: AlarmAll,
  alarmQuota: AlarmQuota,
  alarmCollect: AlarmCollect,
  alarmDeviceOffline: AlarmDeviceOffline,

  outputEmail: OutputEmail,
  outputMqtt: OutputMqtt,
  outputTcp: OutputTcp

};

export default function getComponent(type){
  return typeToComponentMap[type] ? typeToComponentMap[type] : DefaultNode;
}
