import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Input } from 'amos-framework';
import Header from './../../../common/header/Header';

/**
 * property header
 *
 * @class PropertyHeader
 * @extends {Component}
 */
class PropertyHeader extends Component {

  static propTypes = {
    onNodeChange: PropTypes.func,
    className: PropTypes.string
  };

  static defaultProps = {
    onNodeChange(){}
  };

  constructor(props) {
    super(props);
    this.state = {
      value: ''
    };
  }

  onNodeChange = (e) => {
    const value = e.target.value;
    this.setState({
      value
    }, () => this.props.onNodeChange(value));
  }

  renderExtra = () => {
    const { value } = this.state;
    return (
      <Input className="goit-search-ipt" value={value} placeholder="查找" onChange={this.onNodeChange} />
    );
  }

  render() {
    const { className } = this.props;
    const extras = this.renderExtra();

    const cls = classNames('property-header', className);

    return (
      <div className={cls}>
        <Header
          title={null}
          extra={extras}
        />
      </div>
    );
  }
}

export default PropertyHeader;
