import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import Header from './../../../common/header/Header';

/**
 * stage header
 *
 * @class StageHeader
 * @extends {Component}
 */
class StageHeader extends Component {

  constructor(props) {
    super(props);
  }

  onItemClick = (item) => {
    if (item === 'save'){
      this.props.saveStage(this.props.objId);
    } else {
      // exit
      this.props.exitStage();
    }
  }

  renderExtraItem = ({ key, imgContent, text }) => {
    return (
      <div
        key={key}
        className="rule-header-extra-item"
        onClick={() => this.onItemClick(key)}
        title={text}
      >
        {imgContent}
      </div>
    );
  }

  renderExtra = () => {
    const extras = [
      { key: 'exit', imgContent: <img src={require('./../../../../assets/iot/topo/exit.png')} alt='' />, text: '退出' },
      { key: 'save', imgContent: <img src={require('./../../../../assets/iot/topo/save.png')} alt='' />, text: '保存' }
    ];
    return extras.map(extra => {
      return this.renderExtraItem({
        key: extra.key,
        imgContent: extra.imgContent,
        text: extra.text
      });
    });
  }

  render() {

    const { ruleSubObj = {} } = this.props;

    const extras = this.renderExtra();

    return (
      <div className="stage-header">
        <Header
          title={`${ruleSubObj.name || ''}  状态规则`}
          extra={extras}
        />
      </div>
    );
  }
}

StageHeader.propTypes = {
  saveStage: PropTypes.func,
  exitStage: PropTypes.func,
  ruleSubObj: PropTypes.object,
  objId: PropTypes.string
};

StageHeader.defaultProps = {
  saveStage(){},
  exitStage(){}
};

export default StageHeader;
