import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';

/**
 * 基本元素
 *
 * @class GeneralEleContainer
 * @extends {Component}
 */
class GeneralEleContainer extends Component {

  dragStart = (eleType,ruleNodeId,label, ev) => {
    ev.dataTransfer.setData('FlowChartNode', `${eleType}-${ruleNodeId}-${label}` );
  }

  render() {
    const { icon, eleList } = this.props;
    const itemCls = classNames('property-item', icon);
    return (
      <div className="general-ele-container">
        <div className="property-content">
          {
            eleList.map(bl =>(
              <div
                key={bl.object.name}
                className={itemCls}
                draggable
                onDragStart={(e) => this.dragStart(bl.type,bl.key,bl.label, e)}
              >
                <div className="property-item-type"><img src={`/src/assets/iot/rule/${bl.icon}.png`} alt="" /></div>
                <div className="property-item-text">{bl.label}</div>
              </div>))
          }
        </div>
      </div>
    );
  }
}

GeneralEleContainer.propTypes = {
  eleList: PropTypes.array,
  icon: PropTypes.string
};

export default GeneralEleContainer;
