import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Collapse } from 'amos-framework';
import GeneralEleContainer from './GeneralEleContainer';

const Panel = Collapse.Panel;

class RuleEleList extends Component {

  static propTypes = {
    nodelList: PropTypes.array,
    addNode: PropTypes.func,
    mode: PropTypes.string
  };

  static defaultProps = {
    nodelList: []
  };

  calcAllPanelKey = (nodelList) => {
    const keys = [];
    nodelList.forEach(ml => {
      keys.push(ml.object.name);
    });
    return keys;
  }

  render() {
    const { addNode, mode, nodelList } = this.props;
    const allKeys = this.calcAllPanelKey(nodelList);
    return (
      <div className="rule-element-list">
        <Collapse activeKey={allKeys}>
          {
            nodelList.map(ml => (
              <Panel header={ml.label} key={ml.object.name}>
                <GeneralEleContainer icon={ml.icon} eleList={ml.children} addNode={addNode} mode={mode} />
              </Panel>
            ))
          }
        </Collapse>
      </div>
    );
  }
}

export default RuleEleList;
