import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { UUID } from 'amos-tool';
import SingleObjectText from './../trigger/textarea/SingleObjectText';
import SingleRuleText from './../trigger/textarea/SingleRuleText';
import TextAreaBg from './../trigger/textarea/TextAreaBg';
import SingleText from './../trigger/textarea/SingleText';

const defaultLen = 16;
/**
 * 状态文本展示组件
 *
 * @class StatusTextArea
 * @extends {Component}
 */
class StatusTextArea extends Component {

  static propTypes = {
    rules: PropTypes.array,
    object: PropTypes.object,
    onRuleRemove: PropTypes.func,
    onRuleClick: PropTypes.func,
    currentRulesIndex: PropTypes.number,
    sourceStatus: PropTypes.string,
    targetStatus: PropTypes.string
  };

  static defaultProps = {
    rules: [],
    actions: [],
    object: {}
  };

  constructor(props) {
    super(props);

  }

  getRulesIndex = (index, groupRules) => {
    let res = 0;
    groupRules.map((e, i) => {
      if (i < index) {
        res = res + e.length;
      }
    });
    return res;
  }

  render() {
    const { rules, object, onRuleRemove, currentRulesIndex, sourceStatus, targetStatus } = this.props;
    let newRules = [];
    let res = [];
    rules.map(e => {
      if (e.orWidth === 'or') {
        newRules.push(res);
        res = [];
        res.push(e);
      } else {
        res.push(e);
      }
    });
    res.length > 0 && newRules.push(res);
    return (
      <div className="trigger-textarea">
        <TextAreaBg />
        <div className="trigger-textarea-content">
          <SingleObjectText index={1} objectName={object.name} />
          {
            newRules.map((e, index) => (
              <SingleRuleText
                key={UUID.uuid(defaultLen)}
                onRemove={()=>onRuleRemove(this.getRulesIndex(index, newRules), e)}
                showHeightLight={index === currentRulesIndex}
                data={e}
              />
            ))
          }
          {rules.length === 0 && <SingleText text="无条件" />}
          <SingleText title="那么" />
          <SingleText text={`状态：【${sourceStatus}】 转化为 【${targetStatus}】`} />
        </div>
      </div>
    );
  }
}

export default StatusTextArea;
