import React, { Component } from 'react';
import { Modal,Button } from 'amos-antd';
import AddEditRule from './addEditRule';

import './common/index.scss';

/**
 * 新增监测规则
 * @class AddRule
 * @extends {Component}
 */
class AddRule extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      isCycle: false  //周期输入框开关，true显示，false不显示
    };
  }
  /**
   * 初始化
   */
  componentDidMount() {

  }

  /**
   * 打开新增监测规则对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增监测规则对话框
   */
  handleCancel = () => {
    this.setState({ visible: false,isCycle: false });
  }

  typeChange =(value)=>{
    let isCycle;
    if ( '1' === value ){
      isCycle = true;
    } else {
      isCycle = false;
    }
    this.setState({
      isCycle
    });
  }
  render() {
    let destroyOnClose = true;
    let maskClosable = false;
    let isCycle = this.state.isCycle;
    return (
      <span>
        <Button type='primary' icon='plus' onClick={this.onClick} style={{ float: 'left' }} >新增</Button>
        <Modal title='新增任务' visible={this.state.visible} width={800} footer={null} onCancel={this.handleCancel} maskClosable={maskClosable} destroyOnClose={destroyOnClose} >
          <AddEditRule cancel={this.handleCancel}  flag={'add'} {...this.props} monitorRuleInfo={{}} isCycle={isCycle} typeChange={this.typeChange} />
        </Modal>
      </span>
    );
  }
}

AddRule.propTypes = {
};

AddRule.defaultProps = {
};
export default AddRule;
