import {AmosValidate} from '../../../utils/processor';
const validate = AmosValidate.validate;

export default (getFieldProps, type, mssage) => getFieldProps(type, {rules: [{ required: true, message: mssage }]});

/**
 * 数量输入框验证，只能输入正整数
 */
export const numberVilidate = (rule, value, callback) => {
  if (!value) {
    callback();
  } else {
    if (!(/^(0|([1-9]+[0-9]*))(\.(0|([0-9]*)))?$/.test(value))) {
      callback([new Error('请输入数量！')]);
    } else {
      callback();
    }
  }
};

/**
 * 出库数量输入框验证，只能输入正整数，并且要小于库存数量
 */
export const outStoreNumberVilidate = (rule, value, valueCeiling, callback) => {
  if (!value) {
    callback();
  } else {
    if (!(/^(0|([1-9]+[0-9]*))(\.(0|([0-9]*)))?$/.test(value))) {
      callback([new Error('请输入数量！')]);
    } else if(value > valueCeiling){
      callback([new Error('库存数量不足！')]);
    } else {
      callback();
    }
  }
};

const checkNumber = (rule, value, cb) => {
  validate(AmosValidate.naturalRegex, value, cb, '输入数据错误,只能输入正整数！');
};

/**
 * 所有的校验rules
 */
export const rules = {
  rules: [{validator: checkNumber}]
};


 /**
   * 车辆编码校验
   */

export const carCodeValidate = (rule, value, callback) => {
  if (value && !AmosValidate.isUsername(value)) {
    callback('车辆编码不能出现汉字或特殊字符');
  }
  callback();
};


/**
   * 车牌号校验
   */
// export const carNumberValidate = (rule, value, callback) => {
//   const carNumberReg = /[@~`!#$%^&*()_+=<>?/|:;""]/;
//   if (value && carNumberReg.test(value)) {
//     callback('车牌号不能出现特殊字符 ');
//   }
//   callback();
// };

/**
 * textarea文本输入框的字符输入长度限制
 */
export const maxLengthValidate =(rule,value,callback)=>{
  if(value && value.length>50){
    callback('输入长度不能大于50');
  }
  callback();
};
/**
 * 普通文本输入框的字符输入长度限制
 */
export const  generalinputValidate =(rule,value,callback)=>{
  if(value && value.length>32){
    callback('输入长度不能大于32');
  }
  callback();
};
/**
 * phoneNumber 电话号码校验
 */
export const phoneNumberValidate = (rule,value,callback)=>{
  if(value && !AmosValidate.isPhone(value)) {
    callback('请输入0x-xx11位电话号码');
  }
  callback();
};

/**
 * mobileNumber 手机电话
 */
export const mobileNumberValidate = (rule,value,callback)=>{
  if(value && !AmosValidate.isMobile(value)) {
    callback('请输入手机号');
  }
  callback();
};

/**
   * 特殊字符校验
   */
export const specailChartValidate = (rule, value, callback,name) => {
  const carNumberReg = /[@~`!#$%^&*()_+=<>?/|:;\""]/;
  if (value && carNumberReg.test(value)) {
    callback(`${name}不能出现特殊字符 `);
  }
  callback();
};

/**
 * 数字验证
 */
export const isNumber =(rule,value,callback) =>{
  if(value && !AmosValidate.isNum(value)) {
    callback('只能输入数字');
  }
  callback();
};

/**
 * 环信账号非汉字校验
 */
export const checkImvalue =(rule, value, cb,callback) => {
  validate(AmosValidate.alphaNumericRegex, value, cb, '不能出现汉字！');
};
/**
 *环信账号字符长度校验
 */
export const ImvalueLength =( rule,value,callback)=>{
  if((value&&value.length<2)||(value&&value.length>19)){
    callback('请输入2-20位环信账号');
  }
  callback();
};
// export const checkImvalues= {validator: checkImvalue};

/**
 * textarea文本输入框的字符输入长度限制
 */
export const nameInputLength =(rule,value,callback)=>{
  if((value&&value.length<2)||(value && value.length>19)){
    callback('输入长度为2-20!');
  }
  callback();
};
