import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input,Button } from 'amos-antd';
import FilterBtn from './FilterBtn';
import './search.scss';

/**
 * 搜索栏
 */
class SearchBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      filterDisplay: 'hide-div',
      //搜索名称
      inputName: '',
      //选择的筛选条件，格式为filterList: [{name: 'dicIdCommMode',type: 'IN',value: filterList}]
      filterList: {}
    };
  }

  //点击搜索
  onSearch = (values) => {
    let { inputName,filterList } = this.state;
    let { searchParam } = this.props;
    let criterias = {};

    if (inputName.length !== 0){
      criterias.name = inputName;
      Object.assign(searchParam,{ name: inputName });
    } else {
      Object.assign(searchParam,{ name: undefined });
    }
    // if (filterList.types !== undefined && filterList.types.length !== 0)
    // {
    //   criterias.types = filterList.types;
    // }
    // if (filterList.protocolIds !== undefined && filterList.protocolIds.length !== 0)
    // {
    //   criterias.protocolIds = filterList.protocolIds;
    // }
    // if (filterList.commIds !== undefined && filterList.commIds.length !== 0)
    // {
    //   criterias.commIds = filterList.commIds;
    // }
    // if (filterList.industryIds !== undefined && filterList.industryIds.length !== 0)
    // {
    //   criterias.industryIds = filterList.industryIds;
    // }
    this.props.handleCriterias(searchParam);
  }

  onChange = (e) => {
    this.setState({ inputName: e.target.value.trim() });
  }

  //显示筛选栏
  showFilter = () => {
    // this.setState({ filterDisplay: 'show-div' });
  }

  //隐藏筛选栏
  hidFilter = () => {
    // this.setState({ filterDisplay: 'hide-div' });
  }

  obilityValueChange = (obilitySelectedOption) => {
    let { filterList } = this.state;
    let types = [];
    for (let option of obilitySelectedOption) {
      types.push(option.value);
    }
    filterList.types = types;
    this.setState(filterList);
  }

  protocolValueChange = (protocolSelectedOption) => {
    let { filterList } = this.state;
    let protocolIds = [];
    for (let option of protocolSelectedOption) {
      protocolIds.push(option.value);
    }
    filterList.protocolIds = protocolIds;
    this.setState(filterList);
  }

  communityValueChange = (communitySelectedOption) => {
    let { filterList } = this.state;
    let commIds = [];
    for (let option of communitySelectedOption) {
      commIds.push(option.value);
    }
    filterList.commIds = commIds;
    this.setState(filterList);
  }

  industryValueChange = (industrySelectedOption) => {
    let { filterList } = this.state;
    let industryIds = [];
    for (let option of industrySelectedOption) {
      industryIds.push(option.value);
    }
    filterList.industryIds = industryIds;
    this.setState(filterList);
  }


  render() {
    let { filterDisplay } = this.state;
    let filterStyle = `search-filter ${filterDisplay}`;
    let modalStyle = `modal-box ${filterDisplay}`;
    return (
      <div className='search-bar'>
        <div className='search-input'>
          <Input placeholder="请输入设备名称" onFocus={this.showFilter} onChange={this.onChange} />
          <img src={require('./../../../assets/iot/deviceManage/search.png')} alt='' onClick={this.onSearch} />
          <div className={modalStyle} onClick={this.hidFilter} />
          <div className={filterStyle} >
            <FilterBtn
              obilityValueChange={this.obilityValueChange}
              protocolValueChange={this.protocolValueChange}
              communityValueChange={this.communityValueChange}
              industryValueChange={this.industryValueChange}
              {...this.props}
            />
          </div>
        </div>
      </div>
    );
  }
}

SearchBar.propTypes = {
  handleCriterias: PropTypes.func,
  communityOptions: PropTypes.array,
  equiptemplateIndustryOptions: PropTypes.array,
  flag: PropTypes.string,
  searchParam: PropTypes.object
};

export default SearchBar;
