import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Input,Form } from 'amos-antd';
import Icon from 'amos-icon';
import { message } from 'amos-framework';

const createForm = Form.create();
const FormItem = Form.Item;
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 16 }
  }
};
/**
 * 创建视图
 */
class AddView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    let { selectedKeys } = this.props;
    if (selectedKeys.length === 1) {
      this.setState({ visible: true });
    } else {
      message.danger('新选择父节点！');
    }
  }

  addView = (e) => {
    this.onClick();
  }

  //校验
  checkValidate = (rule, value, callback) => {
    let re = new RegExp(/^\S*$/);
    if (re.test(value)) {
      callback();
    } else {
      callback('支持1-20位非空格字符！');
    }
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  /**
   * 提交
   */
  handleSubmit = () => {
    this.props.form.validateFields((errors, values) => {
      if (errors) {
        return;
      }
      let { addTreeData } = this.props;
      addTreeData(values.newNodeName);
      this.props.form.resetFields();
      this.setState({ visible: false });
    });
  }

  render() {
    let { getFieldProps } = this.props.form;
    //显示名称
    const nodeNameProps = getFieldProps('newNodeName', {
      initialValue: '',
      rules: [
          { required: true, message: '支持1-20位非空格字符！' },
          { validator: this.checkValidate }

      ]
    });
    return (
      <div className='add-view-root'>
        <div className="tree-header-extra-item-add" onClick={this.addView} title="创建视图">
          <Icon
            icon="luru"
            style={{
              'position': 'relative',
              'top': '0'
            }}
          />
        </div>
        <Modal maskClosable={false} title='创建视图' closable visible={this.state.visible} onCancel={this.handCancel} onOk={this.handleSubmit} width={350}>
          <Form horizontal>
            <FormItem {...formItemLayout} hasFeedback label='视图名称: '>
              <Input {...nodeNameProps} placeholder='视图名称（支持1-20位非空格字符）' />
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

AddView.propTypes = {
  form: PropTypes.any,
  selectedKeys: PropTypes.array,
  addTreeData: PropTypes.func
};

export default createForm(AddView);
