import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { OltSerUrl } from '../../../consts/urlConsts';
import { deviceCategoryEnum } from  './../../deviceManage/common/DeviceEnum';
import { stringUtil } from './../../deviceManage/common/DeviceLang';

/**
 * 可拖动组件
 *
 * @class DragableCard
 * @extends {Component}
 */
class DragableCard extends Component {
  render() {
    let { cardData,key,startDrag } = this.props;
    let displayImgUrl = cardData.img;
    let srcImgUrl = displayImgUrl === '' ? `${OltSerUrl.fetchDeviceImg}/default.png` : `${OltSerUrl.fetchDeviceImg}/${displayImgUrl}`;
    return (
      <div className='drag-card'>
        <div key={key} className={`btn btn-${cardData.name}-node`} draggable onDragStart={(e) => startDrag(e,'custom',cardData)}>
          <div className='card-info-img'>
            <img src={srcImgUrl} alt='device' />
          </div>
          <div className='card-info-text' title={cardData.name} >
            <p>{cardData.name}</p>
            <p>{cardData ? stringUtil(deviceCategoryEnum,parseInt(cardData.type)) : ''}</p>
          </div>
        </div>
      </div>
    );
  }
}

DragableCard.propTypes = {
  cardData: PropTypes.object,
  key: PropTypes.string,
  startDrag: PropTypes.func
};

export default DragableCard;
