import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Input,Form } from 'amos-antd';
import { message } from 'amos-framework';
import Icon from 'amos-icon';
import { AmosFetch } from '../../../utils/processor';
import OltSerUrl from '../../../consts/urlConsts';

const createForm = Form.create();
const FormItem = Form.Item;
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 16 }
  }
};
/**
 * 编辑视图
 */
class EditView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

   /**
   * 打开编辑对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  addView = (e) => {

  }

  //校验
  checkValidate = (rule, value, callback) => {
    let re = new RegExp(/^\S*$/);
    if (re.test(value)) {
      callback();
    } else {
      callback('支持1-20位非空格字符！');
    }
  }

  /**
   * 关闭编辑对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  /**
   * 提交
   */
  handleSubmit = () => {
    let { currentNode } = this.props;
    this.props.form.validateFields((errors, values) => {
      if (errors) {
        return;
      }
      let persistObj = { id: currentNode.id,name: values.newNodeName,orgCode: currentNode.orgCode };
      this.saveSubgraphData(persistObj);
      this.props.form.resetFields();
      this.setState({ visible: false });
    });
  }

  //保存子图
  saveSubgraphData = (paramdata) => {
    AmosFetch.post(OltSerUrl.addSubgraph, { data: paramdata }).then(res => {
      if (res.ok) {
        return res.text();
      }
      else {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data) => {
      let result = JSON.parse(data);
      let resultStatus = result.result;
      if (resultStatus === 'SUCCESS') {
        //界面刷新
        this.props.getSubviewByOrgCode(this.props.orgId);
        message.success('保存成功');
      } else {
        message.danger(`保存失败：${result.message}`);
      }
    });
  }

  render() {
    let { getFieldProps } = this.props.form;
    let { currentNode } = this.props;
    //显示名称
    const nodeNameProps = getFieldProps('newNodeName', {
      initialValue: currentNode ? currentNode.name : '',
      rules: [
          { required: true, message: '支持1-20位非空格字符！' },
          { validator: this.checkValidate }
      ]
    });
    return (
      <div className='edit-view-root'  style={{ position: 'absolute',top: '-5px',right: '9px','font-size': '1.6rem' }} >
        <div className="tree-header-extra-item-edit" onClick={this.onClick} title="修改视图" >
          <Icon
            icon="edit"
          />
        </div>
        <Modal maskClosable={false} title='修改视图' closable visible={this.state.visible} onCancel={this.handCancel} onOk={this.handleSubmit} width={350}>
          <Form horizontal>
            <FormItem {...formItemLayout} hasFeedback label='视图名称: '>
              <Input {...nodeNameProps} placeholder='视图名称（支持1-20位非空格字符）' />
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

EditView.propTypes = {
  form: PropTypes.any,
  selectedKeys: PropTypes.array,
  editTreeData: PropTypes.func,
  currentNode: PropTypes.object,
  getSubviewByOrgCode: PropTypes.any,
  orgId: PropTypes.any
};

export default createForm(EditView);
