import React from 'react';
import PropTypes from 'prop-types';
import { placement, plumbNodeConnect } from 'amos-jsplumb';
import { sourceEndPoint } from './../modelConf/giotNodeConf';

const { Anchors } = placement;

/**
 * 根节点样式
 *
 * @class GiotNode
 */
@plumbNodeConnect({

  className: 'giot-ele',
  // targetParams: {
  //   allowLoopback: false,
  //   // top
  //   anchor: Anchors.ContinuousTop,
  //   dropOptions: { hoverClass: 'drag-hover' },
  //   isTarget: true
  // },
  sourceParams: {
    allowLoopback: false,
    anchor: Anchors.BottomCenter,
    dropOptions: { hoverClass: 'drag-hover' },
    isSource: true
  },
  endPointParams: [
    {
      params: sourceEndPoint,
      referenceParams: {
        anchor: Anchors.BottomCenter
      }
    }
  ]
})
class GiotNode extends React.Component {
  /*
  componentDidMount() {
    const { config, initNode } = this.props;
    const initConfig = {
      endPointParams: [
        {
          element: this.container,
          params: sourceEndPoint,
          referenceParams: {
            anchor: [[0.5,1,0,0,0,5]],
            uuid: `obj-ep-${Anchors.BottomCenter}-${config.id}`
          }
        }
      ],
      makeSourceParams: {
        // set only drag line
        filter: '.ele-giot-bar',
        allowLoopback: false,
        anchor: Anchors.BottomCenter,
        dropOptions: { hoverClass: 'drag-hover' }
      },
      nodeId: config.id
    };
    initNode(initConfig);
  }*/

  render() {
    let { config } = this.props;
    return (
      <div
        //id={config.id}
        className="node-content-wrapper"
        //style={config.style}
        //ref={node => this.container = node}
      >
        <div className='node-wrapper' />
      </div>
    );
  }
}

GiotNode.propTypes = {
  config: PropTypes.object
};

export default GiotNode;
