import { PlumbEleNode } from 'amos-jsplumb';
import CustomNode from './CustomNode';
import GiotNode from './GiotNode';
import fireNode from './fireNode';

const { DefaultNode } = PlumbEleNode;
//支持的元素类型
const typeToComponentMap = {
  custom: CustomNode, //自定义
  giot: GiotNode, //默认类型
  ...fireNode
};
//获取操作中的元素类型
export default function getComponent(type) {
  return typeToComponentMap[type] ? typeToComponentMap[type] : DefaultNode;
}
