import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button,Select } from 'amos-antd';
import Icon from 'amos-icon';
import OltSerUrl from '../../../../consts/urlConsts';
import { Input } from 'amos-framework';
import { AmosFetch } from '../../../../utils/processor';
import SearchBar from './../../common/SearchBar';
import { deviceCategoryEnum } from  './../../../deviceManage/common/DeviceEnum';
import { enums2array } from './../../../deviceManage/common/DeviceLang';

const Option = Select.Option;
const dataTypeOption = enums2array(deviceCategoryEnum).map((item)=>
  <Option key={item.key} value={item.key}>{item.label}</Option>) ;
/**
 *
 * 设备模板选择
 *
 * @class ChooseEquipmentPanel
 * @extends {Component}
 */
class ChooseEquipmentPanel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      capacityBasicInfo: {},
      interfaceBasicInfo: {},
      expandStyle: 'device-choose-root',
      equiptemplateIndustryDataList: [],
      searchParam: {}
    };
  }

  componentDidMount(){
    this.getVocationData();
  }

  componentWillReceiveProps(nextProps) {

  }

  onSelectedChange = (value,type) => {
    let { searchParam } = this.state;
    searchParam[type] = value;
    this.setState({ searchParam });
  }

  getVocationData = () => {
    //获取行业
    AmosFetch.get(OltSerUrl.equiptemplateIndustry).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let equiptemplateIndustryDataList = [];
        data ? data.dataList.map(e=>{
          equiptemplateIndustryDataList.push(
            <Option key={e.id} value={e.id}>{e.name}</Option>);
        }) : [];
        this.setState({ equiptemplateIndustryOptions: equiptemplateIndustryDataList });
      }
    });
  }

  clickPanel = () => {
    let { expandStyle } = this.state;
    let { changeLeftPanelWidth } = this.props;
    if (expandStyle === 'device-choose-root-hide') {
      expandStyle = 'device-choose-root';
      changeLeftPanelWidth(true);
    } else {
      expandStyle = 'device-choose-root-hide';
      changeLeftPanelWidth(false);
    }
    this.setState({ expandStyle });
  }

  render() {
    let { getPublicDevice,getPrivateDevice,communityOptions,handleCriterias,generatePanelByDevice } = this.props;
    let { expandStyle,equiptemplateIndustryOptions,searchParam } = this.state;
    return (
      <div className={expandStyle}>
        <div className="device-choose-btn" onClick={this.clickPanel}>
          <Icon icon={expandStyle === 'device-choose-root' ? 'right' : 'left'} />
        </div>
        <div className='device-choose-panel' >
          <div className='topo-content-device'>
            <div className='topo-content-device-switch'>
              <div className='private-device'><div className='private-device-label'>我的设备</div></div>
            </div>
            <div className='topo-content-device-filter' >
              <div className='topo-content-device-filter-type'>
                <Select
                  placeholder='类别'
                  allowClear
                  size='default'
                  onChange={(e)=>this.onSelectedChange(e,'type')}
                  style={{ width: '123px' }}
                  dropdownStyle={{ width: '123px' }}
                >
                  {dataTypeOption}
                </Select>
              </div>
              <div className='topo-content-device-filter-industry'>
                <Select
                  placeholder='行业'
                  allowClear
                  size='default'
                  onChange={(e)=>this.onSelectedChange(e,'industryId')}
                  style={{ width: '123px' }}
                  dropdownStyle={{ width: '123px' }}
                >
                  {equiptemplateIndustryOptions}
                </Select>
              </div>
            </div>
            <SearchBar
              searchParam={searchParam}
              communityOptions={communityOptions}
              handleCriterias={handleCriterias}
              equiptemplateIndustryOptions={equiptemplateIndustryOptions}
            />
            <div className='device-choose-content' ref={node => this.deviceChoosePanel = node}>
              {generatePanelByDevice(this.deviceChoosePanel)}
            </div>
          </div>
        </div>
      </div>
    );
  }
}

ChooseEquipmentPanel.propTypes = {
  getPublicDevice: PropTypes.func,
  getPrivateDevice: PropTypes.func,
  communityOptions: PropTypes.func,
  handleCriterias: PropTypes.func,
  generatePanelByDevice: PropTypes.func,
  changeLeftPanelWidth: PropTypes.func
};

export default ChooseEquipmentPanel;
