import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Scrollbars } from 'amos-framework';
import LibItem from './LibItem';
import NewLib from './NewLib';

/**
 *
 *
 * @class LibList
 * @extends {Component}
 */
class LibList extends Component {

  static propTypes = {
    ruleLibList: PropTypes.array,
    toggleUse: PropTypes.func,
    togglePublish: PropTypes.func,
    onDoubleClick: PropTypes.func,
    onCreateObj: PropTypes.func,
    onRemove: PropTypes.func,
    onSetting: PropTypes.func
  };

  static defaultProps = {
    ruleLibList: []
  };

  render() {
    let { ruleLibList, toggleUse, togglePublish, onDoubleClick, onSetting, onCreateObj, onRemove } = this.props;
    return (
      <div className="rule-lib-content">
        <Scrollbars>
          <div className="rule-lib-list">
            <div className="rule-lib-list-inner">
              <NewLib onClick={onCreateObj} />
              {
                ruleLibList.map(rlObj => (
                  <LibItem
                    key={rlObj.key}
                    title={rlObj.name}
                    descr={rlObj.descr}
                    enable={rlObj.isUser}
                    published={rlObj.status === '2'}
                    togglePublish={(checked) => togglePublish(rlObj, checked)}
                    toggleUse={(checked) => toggleUse(rlObj, checked)}
                    onDoubleClick={() => onDoubleClick(rlObj)}
                    onRemove={() => onRemove(rlObj)}
                    onSetting={() => onSetting(rlObj)}
                  />
                ))
              }
            </div>
          </div>
        </Scrollbars>
      </div>
    );
  }
}

export default LibList;
