import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card,Modal,Icon } from 'amos-antd';
import { OltSerUrl } from '../../../../consts/urlConsts';
import EditView from './../EditView';

class subviewItem extends Component {

  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  /**
   * 双击进入规则库界面
   */
  onClick = (obj) => {
    let { subviewInfo,treeName,treeKey,orgId } = this.props;
    subviewInfo.orgName = treeName;
    subviewInfo.expandedKeys = treeKey;
    subviewInfo.orgId = orgId;
    this.props.updateView('2',subviewInfo);
  }


  delView = (e) => {
    let { delSubgraph,subviewInfo } = this.props;
    Modal.confirm({
      title: '删除视图',
      content: '是否删除信息？',
      okText: '确定',
      cancelText: '取消',
      onOk() {
        delSubgraph(subviewInfo.id);
      },
      onCancel() {}
    });
  }

  extraBtn = () => {
    let { subviewInfo } = this.props;
    let res = [];
    res.push(<EditView currentNode={subviewInfo} selectedKeys={subviewInfo.id} key={`edit`} {...this.props} />);
    res.push(<div key={`del`} onClick={this.delView} title='删除视图' className='topo-info-add' ><Icon type='close' /></div>);
    return res;
  }
  render() {
    let { subviewInfo } = this.props;
    let srcImgUrl = `${OltSerUrl.fetchDeviceImg}/equip-view.png`;
    return (
      <div className='table-card'>
        <Card title={subviewInfo.name} extra={this.extraBtn()} >
          <div className='index-add-img' onClick={this.onClick}>
            <img src={srcImgUrl} alt='device' width='184px' height='110px' />
          </div>
        </Card>
      </div>
    );
  }
}

subviewItem.propTypes = {
  subviewInfo: PropTypes.any,
  updateView: PropTypes.func,
  delSubgraph: PropTypes.func,
  orgName: PropTypes.any
};

export default subviewItem;
