import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PubSub } from 'ray-eventpool';
import { TOPO_SWITCH_CONFIG_TOPIC } from './../modelConf/stageConst';

/**
 *
 *
 * @class TopoConfigHeadPanel
 * @extends {Component}
 */
class TopoConfigHeadPanel extends Component {
  constructor(props){
    super(props);
    this.state = {
      selectedKey: 1
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  changeHeadAction = (e,key) => {
    PubSub.publish(TOPO_SWITCH_CONFIG_TOPIC.trigger, {
      selectedKey: key
    });
    this.setState({ selectedKey: key });
  }

  render() {
    let { selectedKey } = this.state;
    let { isNodeSelected } = this.props;
    let basic = 'device-basic-head';
    let capacity = 'device-capacity-head';
    if (isNodeSelected) {
      if (selectedKey === 1) {
        basic = `${basic} device-selected`;
      } else if (selectedKey === 2) {
        capacity = `${capacity} device-selected`;
      }
    } else {
      capacity = `${capacity} subview-selected`;
    }
    return (
      <div className='topo-config-panel-head-root'>
        <div className={basic}>
          <img src={require('./../../../../assets/iot/topo/device-basic.png')} onClick={e => this.changeHeadAction(e,1)} alt='' />
        </div>
        <div className={capacity}>
          <img src={require('./../../../../assets/iot/topo/capacity.png')} onClick={e => this.changeHeadAction(e,2)} alt='' />
        </div>
      </div>
    );
  }
}

TopoConfigHeadPanel.propTypes = {
  isNodeSelected: PropTypes.bool
};

export default TopoConfigHeadPanel;
