import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal, Input, Form } from 'amos-antd';

const createForm = Form.create();
const FormItem = Form.Item;
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 6 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 16 }
  }
};
/**
 * 创建视图
 */
class AddView extends Component {

  //校验
  checkValidate = (rule, value, callback) => {
    let re = new RegExp(/^\S*$/);
    if (re.test(value)) {
      callback();
    } else {
      callback('支持1-20位非空格字符！');
    }
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.props.toggleView(false);
  }

  /**
   * 提交
   */
  handleSubmit = () => {
    this.props.form.validateFields((errors, values) => {
      if (errors) {
        return;
      }
      let { addTreeData } = this.props;
      addTreeData(values.newNodeName);
      this.props.form.resetFields();
      this.props.toggleView(false);
    });
  }

  render() {
    const { form, visible } = this.props;
    const { getFieldProps } = form;
    //显示名称
    const nodeNameProps = getFieldProps('newNodeName', {
      initialValue: '',
      rules: [
          { required: true, message: '支持1-20位非空格字符！' },
          { validator: this.checkValidate }

      ]
    });
    return (
      <div className='add-view-root'>
        <Modal maskClosable={false} title='创建视图' closable visible={visible} onCancel={this.handCancel} onOk={this.handleSubmit} width={350}>
          <Form horizontal>
            <FormItem {...formItemLayout} hasFeedback label='视图名称: '>
              <Input {...nodeNameProps} placeholder='视图名称（支持1-20位非空格字符）' />
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

AddView.propTypes = {
  visible: PropTypes.bool,
  form: PropTypes.any,
  selectedKeys: PropTypes.array,
  addTreeData: PropTypes.func,
  toggleView: PropTypes.func
};

export default createForm(AddView);
