import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Search } from 'amos-framework';
import Icon from 'amos-icon';
import NodeLibList from './nodelib';
import NodeHeader from './../header/NodeHeader';
import { nodelList } from './../modelConf/stageConst';

class TopoNode extends Component {

  static propTypes = {
    communityOptions: PropTypes.array,
    daviceList: PropTypes.array,
    handleCriterias: PropTypes.func,
    getPublicDevice: PropTypes.func,
    getPrivateDevice: PropTypes.func
  };

  renderNodeHeaderExtra = () => {
    const extra = [
      <div key="create-view" className="node-header-extra-item" title="列表">
        <Icon icon="list" />
      </div>,
      <div key="del-view" className="node-header-extra-item" title="卡片">
        <Icon icon="card" />
      </div>
    ];
    return extra;
  }

  render() {

    return (
      <div className='topo-node'>
        <NodeHeader title="设备库" extra={this.renderNodeHeaderExtra()} />
        <Search icon="search" />
        <div className='topo-node-container'>
          <div className="container-title">设备</div>
          <div className="container-inner">
            <NodeLibList nodelList={nodelList} />
          </div>
        </div>
      </div>
    );
  }
}

TopoNode.propTypes = {

};

export default TopoNode;
