import React, { Component } from 'react';
import PropTypes from 'prop-types';

/**
 * 基本元素
 *
 * @class GeneralEleContainer
 * @extends {Component}
 */
class GeneralEleContainer extends Component {

  dragStart = (eleType, label,  ev) => {
    ev.dataTransfer.setData('FlowChartNode', `${eleType}#${label}`);
  }

  render() {
    const { nodeLib } = this.props;
    return (
      <div
        className="nodelib-item"
        draggable
        onDragStart={(e) => this.dragStart(nodeLib.type, nodeLib.text, e)}
      >
        <div className="nodelib-item-pic"><img src={nodeLib.icon} alt="" /></div>
        <div className="nodelib-item-text">{nodeLib.text}</div>
      </div>
    );
  }
}

GeneralEleContainer.propTypes = {
  nodeLib: PropTypes.object
};

export default GeneralEleContainer;
