import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosPlumb, setting } from 'amos-jsplumb';
import { jsPlumbOptions } from './../modelConf/nodeConf';

import getComponent from './../ele';

const {
  dottedConnectionStyle,
  selectedConnectionStyle
} = setting;

//注册类型
const registerTypes = {
  connections: {
    dotted: dottedConnectionStyle,
    selected: selectedConnectionStyle
  },
  endpoints: {}
};

/**
 * 场景(画布)
 *
 * @class TopoStagePlumb
 * @extends {Component}
 */
class TopoStagePlumb extends Component {
  static propTypes = {
    nodes: PropTypes.array,
    connections: PropTypes.array,
    handleDrop: PropTypes.func,
    onPlumbChange: PropTypes.func,
    onSceneCreated: PropTypes.func,
    onPlumbClick: PropTypes.func,
    destroy: PropTypes.bool,
    eventListeners: PropTypes.object
  };

  render() {
    const { nodes, connections, onPlumbChange, onSceneCreated, onPlumbClick, eventListeners, ...restProps } = this.props;

    return (
      <AmosPlumb
        className="amos-plumb-container"
        key="amos-plumb"
        onCreated={onSceneCreated}
        connections={connections}
        nodes={nodes}
        jsPlumbSettings={jsPlumbOptions}
        eventListeners={eventListeners}
        registerTypes={registerTypes}
        onChange={onPlumbChange}
        onPlumbClick={onPlumbClick}
        {...restProps}
        getNodeContent={getComponent}
      >
        {nodes.map((node, i) => {
          const Component = getComponent(node.config.nodeType);
          const key = `nodes-${i}`;
          return <Component key={key} id={node.id} equipmentId={node.equipmentId} showProperty={this.showProperty} deleteNode={this.deleteNode} />;
        })}
      </AmosPlumb>
    );
  }
}

export default TopoStagePlumb;
