import { tools } from 'amos-jsplumb';

export const stagePosition = {
  spaceX: 110,
  spaceY: 60,
  defaultSpaceY: -150,
  ratio_1: 1,
  ratio_2: 1,
  ratio_3: 3
};

export const transferDropData = (data = '') => {
  if (data.indexOf('#') > -1){
    const strs = data.split('#');
    return {
      nodeType: strs[0],
      label: strs[1]
    };
  } else {
    return {
      nodeType: data,
      label: '节点'
    };
  }
};

export const commonAddNode = ({ eleType, labelValue, position }) => {
  return {
    config: {
      label: labelValue,
      type: eleType === 'giot' ? 'source' : 'both',
      nodeType: eleType,
      style: {
        ...position
      }
    },
    id: tools.uuid()
  };
};

