import React, { Component } from 'react';
import PropTypes from 'prop-types';
import GridButton from './../../common/btns/GridButton';
import { Modal } from 'amos-antd';

/**
 * 删除用户信息
 * @class DelUser
 * @extends {Component}
 */
class DelUser extends Component {
  constructor(props) {
    super(props);
  }

  onClick=() => {
    const {selectRows} = this.props;
    let delfunc = this.handleDel;
    if(selectRows.length == 0) {
      Modal.warning({
        title: '系统提示',
        content: '请先选中要删除的信息。',
        okText: '确定'
      });
      return null;
    } else {
      if(selectRows[0].userName === 'admin' && selectRows[0].role.name === 'admin'){
        Modal.warning({
          title: '提示',
          content: '不能操作管理员用户'
        });
      } else {
        Modal.confirm({
          title: '批量删除',
          content: '是否删除所选信息？',
          okText: '确定',
          cancelText: '取消',
          onOk() {delfunc();},
          onCancel() {}
        });
        return null;
      }
    }
  }

  handleDel = () => {
    let {selectRows} = this.props;
    let delIds = [];
    selectRows .map((e)=>{
      delIds.push(e.id);
    });
    this.props.userDelAction(delIds);
  }

  render() {
    const {text} = this.props;
    return (
      <span>
        <GridButton text={text} onClick={this.onClick} icon='delete' />
      </span>
    );
  }
}

DelUser.propTypes = {
  text: PropTypes.string,//批量删除按钮名称
  selectRows: PropTypes.array,//批量删除的数据ID
  url: PropTypes.string,//批量删除的数据的URL
  reload: PropTypes.func,
  userDelAction: PropTypes.func
};

DelUser.defaultProps = {
  text: '删除',
  selectRows: []
};

export default DelUser;
