import React, { Component } from 'react';
import PropTypes from 'prop-types';
import GridButton from './../../common/btns/GridButton';
import SimpleModal from './../../common/modal/SimpleModal';
import EditPassword from './EditPassword';
import {Modal,Form} from 'amos-antd';
const createForm = Form.create();
/**
 * 用户密码修改
 * @class EditPasswordContainer
 * @extends {Component}
 */
class EditPasswordContainer extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      user: {},
      selectId: -1
    };
  }

  onClick = () => {
    let {selectRows} = this.props;
    if(selectRows.length == 0){
      Modal.warning({
        title: '提示',
        content: '请先选中要修改的用户。'
      });
    } else {
      if(selectRows.length > 1){
        Modal.warning({
          title: '提示',
          content: '一次只能修改一个用户'
        });
      } else {
        if(selectRows[0].userName === 'admin' && selectRows[0].role.name === 'admin'){
          Modal.warning({
            title: '提示',
            content: '不能操作管理员用户'
          });
        } else {
          this.props.getUserByIdAction(selectRows[0].id);
          this.setState({visible: true,selectId: selectRows[0].id});
        }
      }
    }
  }

  handleSave = (obj) => {
    obj.id = this.state.selectId;
    this.props.userEditPasswordAction(obj);this.handCancel();
  }

  handCancel = () => {
    this.props.form.resetFields();
    this.setState({visible: false,selectId: ''});
  }
  /**
   * 保存按钮事件
   */
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((errors, values) => {
      if(errors) {
        return;
      }
      this.handleSave(values);
    });
  }

  render() {
    let {text,form,userInfo} = this.props;
    return (
      <span>
        <GridButton text={text} color='#FFF' icon='edit' onClick={this.onClick} />
        <SimpleModal title='修改密码' visible={this.state.visible} onOk={this.handleSubmit} onCancel={this.handCancel}  width={685} >
          <EditPassword user={userInfo.user || {}}  submit={this.handleSubmit} parentform={form}  />
        </SimpleModal>
      </span>
    );
  }
}

EditPasswordContainer.propTypes = {
  text: PropTypes.string,
  reload: PropTypes.func,
  selectRows: PropTypes.array,
  userInfo: PropTypes.object,
  getUserByIdAction: PropTypes.func,
  form: PropTypes.any,
  userEditPasswordAction: PropTypes.func
};

EditPasswordContainer.defaultProps = {
  selectRows: [],
  userInfo: {}
};

export default createForm(EditPasswordContainer);
