import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PieCharts } from 'amos-viz/lib/echarts';
import { browserHistory } from 'amos-react-router';
import { AmosFetch } from '../../../../utils/processor';
import OltSerUrl from '../../../../consts/urlConsts';
import {
  option
} from './chartData/AlarmData';
/**
 * 告警统计
 *
 * @class Alarm
 * @extends {Component}
 */
class Alarm extends Component {
  constructor(props) {
    super(props);
    this.state = {
      count: 0,
      critical: 0,
      major: 0,
      minor: 0
    };
  }

  componentWillMount(){
    let url = `${OltSerUrl.getAlarmCount}`;
      //获取接口通讯方式
    AmosFetch.get(url).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
        {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let critical = data.dataList.critical;
        let major = data.dataList.major;
        let minor = data.dataList.minor;
        let count = critical + major + minor;
        this.setState({ count,critical,major,minor });
      }
    });
  }

  eConsole = (param) => {
    //alert(option.series[0].data.length);
    //alert(option.series[0].data[i]);
    //param.dataIndex 获取当前点击索引，
    //alert(param.dataIndex);
    let dataIndex = param.dataIndex;
    console.log(dataIndex);
    if (dataIndex === 0){
      browserHistory.push('/main/monitor/alarmManage/recentAlarm?level=1');
    } else if (dataIndex === 2) {
      browserHistory.push(`/main/monitor/alarmManage/recentAlarm?level=2`);
    } else if (dataIndex === 4) {
      browserHistory.push(`/main/monitor/alarmManage/recentAlarm?level=3`);
    }
  }

  render() {
    let { count,critical,major,minor } = this.state;
    let array = [];
    let param = {
      type: 'click',
      handler: this.eConsole
    };
    array.push(param);
    return (
      <div className="overview-item-chart">
        <div className="overview-alarm-chart">
          <PieCharts
            pieOps={option(critical,major,minor)}
            chartStyle={{ width: '100%', height: '82px' }}
            eventpool={array}
          />
        </div>
        <div className="overview-alarm-item title">
          <p className="value">{count}</p>
          <p className="">告警总数</p>
        </div>
        <div className="overview-alarm-item first">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 0 })} >{critical}</p>
          <p className=""><span />一级</p>
        </div>
        <div className="overview-alarm-item second">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 2 })} >{major}</p>
          <p className=""><span />二级</p>
        </div>
        <div className="overview-alarm-item third">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 4 })} >{minor}</p>
          <p className=""><span />三级</p>
        </div>
      </div>
    );
  }
}

export default Alarm;
