import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PieCharts } from 'amos-viz/lib/echarts';
import { AmosFetch } from '../../../../utils/processor';
import { browserHistory } from 'amos-react-router';
import OltSerUrl from '../../../../consts/urlConsts';
import {
  option,
  option1,
  option2,
  option3
} from './chartData/TaskData';
/**
 * 账户信息
 *
 * @class AccountInfo
 * @extends {Component}
 */
class AccountInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      optionData: option(0),
      option1Data: option1(0),
      option2Data: option2(0),
      option3Data: option3()
    };
  }

  componentDidMount() {
    AmosFetch.get(OltSerUrl.getMonitorRuleUrl).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let dataList = data.dataList || {};
        let equipPercent = dataList.equipTotal === 0 ? '100%' : ((dataList.coverEquipTotal / dataList.equipTotal) * 100).toFixed(2) + '%';
        this.setState({
          optionData: option(dataList.runRuleCount),
          option1Data: option1(dataList.stopRuleCount),
          option2Data: option2(dataList.coverEquipTotal),
          option3Data: option3(equipPercent)
        });
      }
    });
  }

  eConsole = (param) => {
    //alert(option.series[0].data.length);
    //alert(option.series[0].data[i]);
    //param.dataIndex 获取当前点击索引，
    //alert(param.dataIndex);
    browserHistory.push('/main/monitor/ruleManage');
  }

  render() {
    let { option1Data, option2Data, option3Data, optionData } = this.state;
    let array = [];
    let param = {
      type: 'click',
      handler: this.eConsole
    };
    array.push(param);
    return (
      <div className="overview-item-chart">
        <div className="overview-task-item">
          <PieCharts
            pieOps={optionData}
            chartStyle={{ width: '100%', height: '300px' }}
            eventpool={array}
          />
        </div>
        <div className="overview-task-item">
          <PieCharts
            pieOps={option1Data}
            chartStyle={{ width: '100%', height: '300px' }}
            eventpool={array}
          />
        </div>
        <div className="overview-task-item">
          <PieCharts
            pieOps={option2Data}
            chartStyle={{ width: '100%', height: '300px' }}
            eventpool={array}
          />
        </div>
        <div className="overview-task-item">
          <PieCharts
            pieOps={option3Data}
            chartStyle={{ width: '100%', height: '300px' }}
            eventpool={array}
          />
        </div>
      </div>
    );
  }
}

export default AccountInfo;
