

let rich = {
  white: {
    color: 'black',
    align: 'center',
    padding: [ 5, 0 ]
  }
};
var placeHolderStyle = {
  normal: {
    label: {
      show: false
    },
    labelLine: {
      show: false
    },
    color: 'rgba(0, 0, 0, 0)',
    borderColor: 'rgba(0, 0, 0, 0)',
    borderWidth: 0
  }
};

let getData = (critical,major,minor) => {
  let scaleData = [
    {
      'name': '一级',
      'value': critical,
      'color': '#0099cc'
    },
    {
      'name': '二级',
      'value': major,
      'color': '#ff9900'
    },
    {
      'name': '三级',
      'value': minor,
      'color': '#009966'
    }
  ];
  let data = [];
  for (let i = 0; i < scaleData.length; i++) {
    data.push({
      value: scaleData[i].value,
      name: scaleData[i].name,
      itemStyle: {
        normal: {
          borderWidth: 4,
          shadowBlur: 10,
          color: 'black',
          borderColor: scaleData[i].color,
          shadowColor: 'rgba(142, 152, 241, 0.6)'
        }
      }
    }, {
      value: 0,
      name: '',
      itemStyle: placeHolderStyle
    });
  }
  return data;
};


let seriesObj = (critical,major,minor)=>{
  let obj =  [{
    name: '',
    type: 'pie',
    clockWise: false,
    radius: [ 33, 36 ],
    hoverAnimation: false,
    itemStyle: {
      normal: {
        label: {
            show: false
          },
        labelLine: {
            show: false
          }
      }
    },
    data: getData(critical,major,minor)
  }];
  return obj;
};

export const option = (critical,major,minor)=>{
  let opt =  {
    // backgroundColor: '#04243E',
    tooltip: {
      show: false
    },
    legend: {
      show: false
    },
    toolbox: {
      show: false
    },
    series: seriesObj(critical,major,minor)
  };
  return opt;
};
