

let rich = {
  white: {
    color: 'black',
    align: 'center',
    padding: [ 5, 0 ]
  }
};

var placeHolderStyle = {
  normal: {
    label: {
      show: false
    },
    labelLine: {
      show: false
    },
    color: 'rgba(0, 0, 0, 0)',
    borderColor: 'rgba(0, 0, 0, 0)',
    borderWidth: 0
  }
};

let dataInfo = (pubCount,priCount) =>{
  let data = [];
  let scaleData = [
    {
      'name': '公开设备',
      'value': pubCount,
      'color': '#0099cc'
    },
    {
      'name': '私有设备',
      'value': priCount,
      'color': '#ff9900'
    }
  ];
  for (let i = 0; i < scaleData.length; i++) {
    data.push({
      value: scaleData[i].value,
      name: scaleData[i].name,
      itemStyle: {
        normal: {
          borderWidth: 4,
          shadowBlur: 10,
          color: 'black',
          borderColor: scaleData[i].color,
          shadowColor: 'rgba(142, 152, 241, 0.6)'
        }
      }
    }, {
      value: 0,
      name: '',
      itemStyle: placeHolderStyle
    });
  }

  return data;
};


let seriesObj = (pubCount,priCount) => {
  let obj = [{
    name: '',
    type: 'pie',
    clockWise: false,
    radius: [ 33, 36 ],
    hoverAnimation: false,
    itemStyle: {
      normal: {
        label: {
          show: false
        },
        labelLine: {
          show: false
        }
      }
    },
    data: dataInfo(pubCount,priCount)
  }];
  return obj;
};

export const option = (pubCount,priCount) => {
  let opt = {
    // backgroundColor: '#04243E',
    tooltip: {
      show: false
    },
    legend: {
      show: false
    },
    toolbox: {
      show: false
    },
    series: seriesObj(pubCount,priCount)
  };
  return opt;
};
