

let rich = {
  white: {
    color: 'black',
    align: 'center',
    padding: [ 5, 0 ]
  }
};
var placeHolderStyle = {
  normal: {
    label: {
      show: false
    },
    labelLine: {
      show: false
    },
    color: 'rgba(0, 0, 0, 0)',
    borderColor: 'rgba(0, 0, 0, 0)',
    borderWidth: 0
  }
};

let getDataInfo = (controller,sensor,collector) => {
  let data = [];
  let scaleData = [{
    'name': '采集设备',
    'value': collector,
    'color': '#0099cc'
  },
  {
    'name': '传输设备',
    'value': sensor,
    'color': '#ff9900'
  },
  {
    'name': '控制设备',
    'value': controller,
    'color': '#009966'
  }];
  for (let i = 0; i < scaleData.length; i++) {
    data.push({
      value: scaleData[i].value,
      name: scaleData[i].name,
      itemStyle: {
        normal: {
          borderWidth: 5,
          shadowBlur: 30,
          color: 'black',
          borderColor: scaleData[i].color,
          shadowColor: 'rgba(142, 152, 241, 0.6)'
        }
      }
    }, {
      value: 0,
      name: '',
      itemStyle: placeHolderStyle
    });
  }
  return data;
};


let seriesObj = (controller,sensor,collector) =>{
  let scaleData = [{
    'name': '采集设备',
    'value': collector,
    'color': '#0099cc'
  },
  {
    'name': '传输设备',
    'value': sensor,
    'color': '#ff9900'
  },
  {
    'name': '控制设备',
    'value': controller,
    'color': '#009966'
  }];
  let obj =  [{
    name: '',
    type: 'pie',
    clockWise: false,
    radius: [ 95, 100 ],
    hoverAnimation: false,
    startAngle: [180],
    itemStyle: {
      normal: {
        label: {
          textStyle: {
            fontSize: 16,
            color: '#235894'
          },
          show: true,
          position: 'outside',
          color: 'black',
          formatter(params) {
            var percent = 0;
            var total = 0;
            for (var i = 0; i < scaleData.length; i++) {
              total += scaleData[i].value;
            }
            if (total === 0){
              percent = (0 * 100).toFixed(0);
            } else {
              percent = ((params.value / total) * 100).toFixed(0);
            }
            if (params.name !== '') {
              return `${params.name}\n{white|` + `占比${percent}%}`;
            } else {
              return '';
            }
          },
          rich
        },
        labelLine: {
          show: true
        }
      }
    },
    data: getDataInfo(controller,sensor,collector)
  }];
  return obj;
};

export const option = (controller,sensor,collector) =>{
  console.log(`${controller}------${sensor}------${collector}`);
  let opt = {
    // backgroundColor: '#04243E',
    title: {
      text: '总纳管设备数',
      left: 'center',
      textStyle: {
        color: 'black'
      }
    },
    tooltip: {
      show: false
    },
    legend: {
      show: false
    },
    toolbox: {
      show: false
    },
    series: seriesObj(controller,sensor,collector)
  };
  return opt;
};

// Schema:
// date,AQIindex,PM2.5,PM10,CO,NO2,SO2
var dataBJ = [

    [ 234,185,230,4.09,123 ]
];

var dataGZ = [
    [ 26,37,27,1.163,27,13 ]

];

var dataSH = [
    [ 91,45,125,0.82,34,23 ]

];

var lineStyle = {
  normal: {
    width: 1,
    opacity: 0.5
  }
};

export const option2 = (electric,fire,net,others,industrial) =>{
  let opt = {
    // backgroundColor: '#161627',
    title: {
      text: '设备模型分别统计',
      left: 'center',
      textStyle: {
        color: 'black'
      }
    },
    legend: {
      bottom: 5,
      data: [],
      itemGap: 20,
      textStyle: {
        color: '#fff',
        fontSize: 15
      },
      selectedMode: 'single'
    },
    radar: {
      indicator: [
          { name: '消防', max: 100 },
          { name: '网络', max: 100 },
          { name: '电力', max: 100 },
          { name: '工业控制', max: 100 },
          { name: '其他', max: 100 }
      ],
      shape: 'circle',
      splitNumber: 5,
      radius: 100,
      name: {
        textStyle: {
          color: 'black'
        }
      },
      splitLine: {
        lineStyle: {
          color: [
          '#0099cc', '#fcbd4d',
          '#fb352e', '#7ed142',
          '#f33af6'
        ].reverse()
        }
      },
      splitArea: {
        show: false
      },
      axisLine: {
        lineStyle: {
          color: 'rgba(238, 197, 102, 0.5)'
        }
      }
    },
    series: [
      {
        name: '消防',
        type: 'radar',
        lineStyle,
        data: [ electric,net,fire,others,industrial ],
        symbol: 'none',
        itemStyle: {
          normal: {
            color: '#F9713C'
          }
        },
        areaStyle: {
          normal: {
            opacity: 0.1
          }
        }
      }
    ]
  };
  return opt;
};
