"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.nodeOptions = exports.registerTypes = exports.jsPlumbOptions = exports.targetEndpoint = exports.sourceEndPoint = exports.endpointType = exports.connectorType = exports.lines = exports.colors = exports.allAroundAnchor = exports.allCenterAroundAnchor = void 0;
var _amosJsplumb = require("amos-jsplumb"),
  Anchors = _amosJsplumb.placement.Anchors,
  allCenterAroundAnchor = [Anchors.TopCenter, Anchors.RightMiddle, Anchors.BottomCenter, Anchors.LeftMiddle];
exports.allCenterAroundAnchor = allCenterAroundAnchor;
var allAroundAnchor = [Anchors.Top, Anchors.Right, Anchors.Bottom, Anchors.Left];
exports.allAroundAnchor = allAroundAnchor;
var colors = {
  basic: "black",
  dotFill: "#40e2e0",
  dotStroke: "#CCC",
  startDrawLine: "#FF7F0E",
  line: "#4e5568",
  lineActived: "#FF7F0E",
  dotColor: "#0099ff",
  epTarget: "",
  epSource: "",
  hoverColor: "#216477"
};
exports.colors = colors;
var lines = {
    thin: 1,
    normal: 2,
    mid: 3,
    large: 4,
    most: 5
  },
  connectorPaintStyle = {
    strokeWidth: (exports.lines = lines).normal,
    stroke: colors.line,
    joinstyle: "round",
    outlineStroke: "transparent",
    outlineWidth: lines.normal
  },
  connectorHoverStyle = {
    strokeWidth: lines.mid,
    stroke: colors.lineActived,
    outlineWidth: lines.most,
    outlineStroke: "white"
  },
  endpointHoverStyle = {
    fill: colors.lineActived,
    stroke: colors.lineActived
  },
  connectorType = {
    Flowchart: ["Flowchart", {
      stub: [40, 60],
      gap: 10,
      cornerRadius: 5,
      alwaysRespectStubs: !0
    }],
    Bezier: ["Bezier", {
      stub: 0,
      curviness: 150
    }],
    StateMachine: ["StateMachine", {
      curviness: 10,
      margin: 5,
      proximityLimit: 80,
      loopbackRadius: 25,
      showLoopback: !0,
      orientation: "clockwise"
    }],
    Straight: ["Straight", {
      stub: 0,
      sourceStub: 10,
      targetStub: 10,
      gap: 0,
      sourceGap: 5,
      targetGap: 5
    }]
  };
exports.connectorType = connectorType;
var endpointType = {
  Blank: "Blank",
  Dot: ["Dot", {
    radius: 10
  }],
  Image: ["Image", {
    src: ""
  }],
  Rectangle: ["Rectangle", {
    width: 10,
    height: 10
  }]
};
exports.endpointType = endpointType;
var useConnector = connectorType.Bezier,
  useEndpoint = endpointType.Rectangle,
  sourceEndPoint = {
    endpoint: useEndpoint,
    paintStyle: {
      stroke: "#7AB02C",
      fill: "transparent",
      radius: 7,
      strokeWidth: 1
    },
    isSource: !0,
    connector: useConnector,
    connectorStyle: connectorPaintStyle,
    hoverPaintStyle: endpointHoverStyle,
    connectorHoverStyle: connectorHoverStyle,
    dragOptions: {}
  };
exports.sourceEndPoint = sourceEndPoint;
var targetEndpoint = {
  endpoint: useEndpoint,
  paintStyle: {
    fill: "#7AB02C",
    radius: 7
  },
  hoverPaintStyle: endpointHoverStyle,
  maxConnections: -1,
  dropOptions: {
    hoverClass: "hover",
    activeClass: "active"
  },
  isTarget: !0
};
exports.targetEndpoint = targetEndpoint;
var jsPlumbOptions = {
  HoverPaintStyle: {
    dashstyle: "solid",
    stroke: colors.lineActived,
    strokeWidth: lines.normal
  },
  PaintStyle: connectorPaintStyle,
  ConnectionOverlays: [
    ["Arrow", {
      id: "arrow",
      location: 1,
      foldback: .8,
      width: 10,
      length: 15
    }]
  ],
  Connector: useConnector,
  Endpoint: useEndpoint,
  EndpointStyle: {
    radius: 10
  },
  EndpointHoverStyle: endpointHoverStyle,
  LogEnabled: !1,
  MaxConnections: 1,
  ReattachConnections: !1
};
exports.jsPlumbOptions = jsPlumbOptions;
var registerTypes = {
  connections: {
    dotted: {
      paintStyle: {
        dashstyle: "3 5",
        outlineStroke: "transparent",
        stroke: colors.dotColor,
        strokeWidth: lines.normal
      }
    },
    selected: {
      paintStyle: {
        dashstyle: "solid",
        strokeWidth: lines.mid,
        outlineStroke: "transparent",
        outlineWidth: lines.mid,
        stroke: colors.lineActived
      }
    }
  },
  endpoints: {}
};
exports.registerTypes = registerTypes;
var nodeOptions = {
  common: {},
  object: {
    endPointParams: [{
      params: sourceEndPoint,
      referenceParams: {
        anchor: Anchors.RightMiddle
      }
    }],
    makeSourceParams: {
      filter: ".ele-object-bar",
      allowLoopback: !1,
      anchor: Anchors.Right,
      dropOptions: {
        hoverClass: "drag-hover"
      }
    }
  },
  status: {
    endPointParams: [{
      params: sourceEndPoint,
      referenceParams: {
        anchor: Anchors.RightMiddle
      }
    }, {
      params: targetEndpoint,
      referenceParams: {
        anchor: Anchors.LeftMiddle
      }
    }],
    makeTargetParams: {
      allowLoopback: !1,
      anchor: Anchors.ContinuousLeft,
      dropOptions: {
        hoverClass: "drag-hover"
      },
      isTarget: !0
    },
    makeSourceParams: {
      filter: ".ele-source-bar",
      allowLoopback: !1,
      anchor: Anchors.Right,
      dropOptions: {
        hoverClass: "drag-hover"
      }
    }
  },
  trigger: {
    endPointParams: [{
      params: sourceEndPoint,
      referenceParams: {
        anchor: Anchors.RightMiddle
      }
    }, {
      params: targetEndpoint,
      referenceParams: {
        anchor: Anchors.LeftMiddle
      }
    }],
    makeTargetParams: {
      allowLoopback: !1,
      anchor: Anchors.ContinuousLeft,
      dropOptions: {
        hoverClass: "drag-hover"
      },
      isTarget: !0
    },
    makeSourceParams: {
      filter: ".ele-source-bar",
      allowLoopback: !1,
      anchor: Anchors.Right,
      dropOptions: {
        hoverClass: "drag-hover"
      }
    }
  },
  flowAction: {
    endPointParams: [{
      params: targetEndpoint,
      referenceParams: {
        anchor: Anchors.LeftMiddle
      }
    }],
    makeTargetParams: {
      allowLoopback: !1,
      anchor: Anchors.ContinuousLeft,
      dropOptions: {
        hoverClass: "drag-hover"
      },
      isTarget: !0
    }
  }
};
exports.nodeOptions = nodeOptions;
