import * as endConf from 'amos-processor/lib/config/endconf';
// import completeSecurityUrl, { completeSecurityWsUrl } from 'amos-security/lib/consts/securityUrl';

const completePrefix = endConf.completePrefix;
let baseURI = endConf.baseURI;

const securityBaseURI = endConf.securityBaseURI;
const mockURI = 'http://172.16.10.161:8087/';
const AmosConfig = endConf.AmosConfig;
const securityBaseWsURI = AmosConfig.wsURI.securityBaseURI;
const realTimeMetricDataWsURL =  AmosConfig.wsURI.realTimeMetricDataURL;
const onlineDataTestWsURL = AmosConfig.wsURI.onlineTestWsURL;

export const onlineTestWsURL = onlineDataTestWsURL;
// export const SecurityUrl = completeSecurityUrl(securityBaseURI);
// export const SecurityWsUrl = completeSecurityWsUrl(securityBaseWsURI);
export const realTimeMetricWsURL = realTimeMetricDataWsURL;

const secExVerson = 'v1';
const securityUrlWithVersion = `${securityBaseURI}/${secExVerson}`;

export const secExtUrl = {
  //*************************************
  //  op 内置接口url
  //*************************************
  opMenusUrl: completePrefix(securityBaseURI,'permissionItem/allPermission-tree'),
  opSearchMenusUrl: completePrefix(securityBaseURI,'permissionItem/searchPermission-tree?nodeName={nodeName}&type={type}'),
  themesUrl: completePrefix(mockURI,'themes'), //用户主题集合
  saveUserThemsUrl: completePrefix(mockURI,'themes'), //保存用户选择的主题信息
  uploadThemUrl: completePrefix(mockURI,'themes'), //上传主题文件
  removeUserThemUrl: completePrefix(mockURI,'themes'), //用户删除自己的主题（除过默认的）

  deskListUrl: completePrefix(securityBaseURI,'pfAppManager/appview/listDesk'),//获取桌面集合
  deskAddUrl: completePrefix(securityBaseURI,'pfAppManager/appview/addDesk'),//添加桌面
  deskEditUrl: completePrefix(securityBaseURI,'pfAppManager/appview/editDesk'),//编辑桌面
  deskRemoveUrl: completePrefix(securityBaseURI,'pfAppManager/appview/delDesk'),//删除桌面


    // 新权限接口
  // currentUserUrl: completePrefix(securityBaseURI, `${secExVerson}/user/me`), // 获取当前登陆用户信息
  currentUserUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/agencyuser/me`), // 获取当前登陆用户信息
  // systemMenusUrl: completePrefix(securityBaseURI, `${secExVerson}/permission/tree/menu?code={code}&userId={userId}`), // 获取当前系统所有菜单
  systemMenusUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/permission/tree/me`), // 获取当前系统所有菜单
  // permissionsCompanyUrl: completePrefix(securityBaseURI, `${secExVerson}/user/me`), // 登陆用户权限所有公司
  permissionsCompanyUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/agencyuser/me`), // 登陆用户权限所有公司
  // permissionsMenusUrl: completePrefix(securityUrlWithVersion, '/permission/tree/{roleSeq}'), // 登陆用户系统权限菜单---TODO新版待修改
  permissionsMenusUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/permission/tree/role?roleSeq={roleSeq}`), // 登陆用户系统权限菜单

  loginUrl: completePrefix(securityBaseURI, `${secExVerson}/system/login`), // 登陆获取accessToken
  loginOutUrl: completePrefix(securityBaseURI, `${secExVerson}/system/loginOutr`), // 登陆用户系统权限菜单

  regionSelectUrl: completePrefix(baseURI, 'iot/iot/safe/save/curCompany') // 登陆用户系统权限菜单
};

const iecBaseURI = completePrefix(baseURI, 'iec/');

export const IecUrl = {
  channelUrl: completePrefix(iecBaseURI, 'channel'),
  deleteChannelUrl: completePrefix(iecBaseURI, 'channel/serviceId/{id}'),
  channelListUrl: completePrefix(iecBaseURI, 'channel/{type}'),
  channelPointUrl: completePrefix(iecBaseURI, 'point/{channel}'),
  iecChannelPointUrl: completePrefix(iecBaseURI, 'point/iec?channelNo={channelNo}&pointType={pointType}'),
  pointUrl: completePrefix(iecBaseURI, 'point'),
  deletePointUrl: completePrefix(iecBaseURI, 'point?ids={ids}'),
  iecDownloadIecTmplUrl: completePrefix(iecBaseURI, 'point/export/model'),
  iecImportUrl: completePrefix(iecBaseURI, 'point/import?serviceId={serviceId}&pointType={pointType}'),

}

baseURI = baseURI + 'iot/';

export const OltSerUrl = {
  //脚本语言类型
  scriptLangType: completePrefix(baseURI, 'dic/script-type'),
  //接口通讯方式
  communityProtocol: completePrefix(baseURI, 'dic/community'),
  //获取设备原型行业种类
  equiptemplateIndustry: completePrefix(baseURI, 'dic/equiptemplate-industry'),
  //*************设备管理*****************
  addDevice: completePrefix(baseURI, 'device/device-persistence'),//新增设备
  fetchDeviceById: completePrefix(baseURI, 'device/template-entity'),//根据ID查询设备
  pageDevice: completePrefix(baseURI, 'device/page-device'),//分页查询设备
  realDevice: completePrefix(baseURI, 'device/real-list'),//查询真实设备
  getRealDevice: completePrefix(baseURI, 'device/real-device'),//查询真实设备
  fetchDeviceInterfaceById: completePrefix(baseURI, 'device/template-interface'),//根据ID查询设备接口
  fetchCapacityListInfoById: completePrefix(baseURI, 'device/capacity-intfc-property'),//根据ID查询能力的list属性信息
  fetchDeviceImg: completePrefix(baseURI, 'images'),//设备图片地址
  deviceAttributeUpdate: completePrefix(baseURI, 'device/device-attribute-update'),//新增/更新设备属性
  deleteDeviceProperty: completePrefix(baseURI, 'device/device-property-eliminate'),//删除设备属性
  deviceInterfaceUpdate: completePrefix(baseURI, 'device/device-interface-update'),//新增/更新设备接口
  deleteDeviceInterface: completePrefix(baseURI, 'device/device-interface-eliminate'),//删除设备接口
  deviceCapacityAdd: completePrefix(baseURI, 'device/device-capacity-add'),//新增设备能力
  deleteDeviceCapacity: completePrefix(baseURI, 'device/device-capacity-eliminate'),//删除设备能力
  capacityIntfUpdate: completePrefix(baseURI, 'device/capacity-intf-update'),//新增/编辑能力接口
  deleteCapacityInterface: completePrefix(baseURI, 'device/capacity-interface-eliminate'),//删除能力接口
  capacityPropertyUpdate: completePrefix(baseURI, 'device/capacity-property-update'),//新增/编辑能力属性
  capacityPropertyUrl: completePrefix(baseURI, 'device/capacity-property'),//能力属性
  deleteCapacityProperty: completePrefix(baseURI, 'device/capacity-property-eliminate'),//删除能力属性
  deviceBasicInfoUpdate: completePrefix(baseURI, 'device/device-basic-info-update'),//设备基本信息编辑
  deleteDeviceById: completePrefix(baseURI, 'device/device-eliminate'),//删除设备信息
  getDeviceCount: completePrefix(baseURI, 'device/device-count'),//获取设备的数量统计
  findEquipmentById: completePrefix(baseURI, 'device/device-info'),//根据设备id获取设备信息
  getDeviceCountByType: completePrefix(baseURI, 'device/equipTempTypeStatic'),
  getDeviceCountByIndustry: completePrefix(baseURI, 'device/equipTempIndustryStatic'),
  fetchTemplateStatistics: completePrefix(baseURI, 'device/eqpTempl/list'),
  fetchTemplatEquipments: completePrefix(baseURI, 'device/eqpTempl/equipments'),
  ToDoDeviceTest: completePrefix(baseURI, 'device/test'),
  fetchTemplatIntfc: completePrefix(baseURI, 'intfc'),
  quotaSelecteds: completePrefix(baseURI, 'device/quota-info'),
  editEquipmentName: completePrefix(baseURI, 'device/equipment/property'),
  delEquipmentById: completePrefix(baseURI, 'device/delEquipment'),
  fetchTemplatOrEqpIntfc: completePrefix(baseURI, 'intfc'),
  fetchTemplatOrEqpQuota: completePrefix(baseURI, 'device'),
  addEditEquipment: completePrefix(baseURI, 'device/saveEquipment'),
  exportData: completePrefix(baseURI, 'device/export'),
  fetchCapacityInterface: completePrefix(baseURI, 'device/capacity-intfc'),//获取能力接口
  updateEquipmentConfig: completePrefix(baseURI, 'device/equipment/single-property'),//更新设备配置信息
  getDeviceModeData: completePrefix(baseURI, 'device/equipment/modelDate'),//查询设备型号
  //*************************************

  //*************接口*****************
  deviceInterfaceByid: completePrefix(baseURI, 'intfc/attributes'), //通过id查询设备接口
  fetchInterfaceCount: completePrefix(baseURI, 'intfc/statistics'),//统计接口信息
  interfaceDataList: completePrefix(baseURI, 'intfc/list'),//首页接口数据
  interfaceSave: completePrefix(baseURI, 'intfc/add'),//新增接口
  interfaceDelete: completePrefix(baseURI, 'intfc/delete'),//根据id删除接口信息
  intfcAttrSave: completePrefix(baseURI, 'intfc/{id}/attribute/edit'),//编辑/保存接口属性
  intfcAttrDelete: completePrefix(baseURI, 'intfc/attribute/delete'),//删除接口属性
  //*************************************


  //*************协议*****************
  protocolSave: completePrefix(baseURI, 'protocol/save'),//新增协议
  protocolDataList: completePrefix(baseURI, 'protocol/list'),//首页协议数据
  protocolDetail: completePrefix(baseURI, 'protocol/{id}/detail'),//根据ID获取协议详情
  protocolDelete: completePrefix(baseURI, 'protocol/delete'),//根据id删除协议信息
  fetchProtocolCount: completePrefix(baseURI, 'protocol/statistics'),//统计协议信息
  //*************************************

  //**************拓扑*******************
  fetchSubgraphInfos: completePrefix(baseURI, 'company/manger-tree'),//获取子图信息
  // fetchSubgraphInfos: completePrefix(securityBaseURI, `${secExVerson}/company/tree`),//获取子图信息

  // fetchSubgraphInfos: completePrefix(baseURI, 'topo/subgraph-entitys'),//获取子图信息
  fetchSubgraphInfoById: completePrefix(baseURI, 'topo/subgraph-entity'),//根据ID获取子图信息
  addSubgraph: completePrefix(baseURI, 'topo/subgraph-persistence'),//保存子图信息
  delSubgraph: completePrefix(baseURI, 'topo/subgraph-eliminate'),//删除子图信息
  addSubgraphData: completePrefix(baseURI, 'topo/subgraph-data-persistence'),//保存子图信息（节点和连线）
  updateNodeName: completePrefix(baseURI, 'topo/device-name-update'),//节点基本信息编辑
  getEquipmentData: completePrefix(baseURI, 'device/equipment-entity'),//获取设备信息
  addEquipmentAttribute: completePrefix(baseURI, 'device/equipment-attribute'),//添加设备属性
  deleteNodeById: completePrefix(baseURI, 'topo/node-eliminate'),//按照ID删除设备
  deleteConnectionById: completePrefix(baseURI, 'topo/connection-eliminate'),//按照ID删除线路
  getRealDataByDeviceId: completePrefix(baseURI, 'topo/real-data'),//根据设备Id查询实时数据
  fetchSubgraphEquipments: completePrefix(baseURI, 'topo/subgraph-equipments'),//获取指定子图的设备
  fetchSingleSubgraphEquipments: completePrefix(baseURI, 'topo/single-subgraph-equipments'),//获取指定子图的设备
  getSubviewByOrgCode: completePrefix(baseURI, 'topo/subgraph-orgcode'),//根据公司id获取视图数据
  deleteLinkById: completePrefix(baseURI, 'topo/link-eliminate'),//按照ID删除线路
  editOrgImgUrl: completePrefix(baseURI, 'topo/org-img'),//编辑公司背景图片
  fetchOrgImgs: completePrefix(baseURI, 'topo/imgs'),//获取公司背景图片
  oneOpenOrClose: completePrefix(baseURI, 'topo/rule-switch'),//启用或者关闭视图
  fetchSimpleOrgImgs: completePrefix(baseURI, 'topo/simple-imgs'),//获取公司背景图片
  editSubviewImg: completePrefix(baseURI, 'topo/subgraph-img'),//编辑子图背景图片
 // fetchCompanyById: completePrefix(securityBaseURI, 'company/unique-company'),//获取公司信息

  fetchCompanyById: completePrefix(securityBaseURI, `privilege/${secExVerson}/company`),//获取公司信息
  fetchTopoDevice: completePrefix(baseURI, 'device/topo-device'),//查询拓扑中设备所有配置信息
  addeEditEqpImg: completePrefix(baseURI, 'device/eqipment-img'),//新增编辑设备图片
  //*************************************

  //*************智维规则*****************
  monitorRuleDataList: completePrefix(baseURI, 'rule/list'),//首页列表数据
  monitorRuleAddOrUpdate: completePrefix(baseURI, 'rule/add-update'),//新增或者修改任务数据
  monitorRuleDel: completePrefix(baseURI, 'rule/monitor-del'),//删除一条任务信息
  monitorRuleNameIsReplace: completePrefix(baseURI, 'rule/name-replace'),//校验名称是否重复
  monitorIsenable: completePrefix(baseURI, 'rule/monitor-enable'),//启用或关闭一条任务
  monitorRuleData: completePrefix(baseURI, 'rule/task-list'),//全部数据

  //*************告警*****************
  getHistoryAlarm: completePrefix(baseURI, 'alarm/list'),//查询告警
  deleteAlarm: completePrefix(baseURI, 'alarm/delete'),//删除告警
  getAlarmCount: completePrefix(baseURI, 'alarm/presentAlarm-static'),//获取告警个类型数量

  //*************历史数据*****************
  getHistoryData: completePrefix(baseURI, 'history/history-condition-data'),//查询历史数据
  getDeviceTemplateByEgpId: completePrefix(baseURI, 'history/template-entity'),//根据设备ID查询设备模板信息

  //*************规则管理*****************
  rulelibListUrl: completePrefix(baseURI, 'rulemanage/rule-list'), //获取所有的规则
  addSingleRule: completePrefix(baseURI, 'rulemanage/rule'), //新增规则
  editSingleRule: completePrefix(baseURI, 'rulemanage/rule'), //编辑规则
  removeObjUrl: completePrefix(baseURI, 'rulemanage/rule'),//删除规则
  changeRule: completePrefix(baseURI, 'rulemanage/rule-enabled'),//启用/停用规则
  changeAllRule: completePrefix(baseURI, 'rulemanage/all-rule-enabled'),//启用/停用全部规则

  //*************规则部署*****************
  saveStageViewUrl: completePrefix(baseURI, 'ruledeploy/rule-data'),//保存规则部署图
  initStageViewUrl: completePrefix(baseURI, 'rulemanage/rule'),//获取指定规则的部署图
  delViewNodeUrl: completePrefix(baseURI, 'ruledeploy/nodevo'),//删除指定节点
  updateNodeLabelUrl: completePrefix(baseURI, 'ruledeploy/nodevoname'),//编辑节点名称
  addViewNodeUrl: completePrefix(baseURI, 'ruledeploy/nodevo'),//新增节点
  updateNodeUrl: completePrefix(baseURI, 'ruledeploy/nodevo'),//编辑节点
  fetchNodeConfig: completePrefix(baseURI, 'ruledeploy/nodevo'),//获取节点信息
  getRuleElements: completePrefix(baseURI, 'ruledeploy/elements'),//获取规则节点元素

  //***********总览 *************************
  getMonitorRuleUrl: completePrefix(baseURI, 'rule/monitorRule-static'),//总览-任务统计

  //***********插件 *************************
  getSectionsByParam: completePrefix(baseURI, 'section/sections-entitys')//条件查询插件
};

const OltWsUrl = {
  topoWs: completePrefix(securityBaseURI, 'topo.ws')
};

export { OltWsUrl };

export default OltSerUrl;
