import DeviceInterface from './view/deviceInterface';
import DeviceProtocol from './view/deviceProtocol';
import DeviceManage from './view/deviceManage';
import RuleManage from './view/ruleManage';
import TopoManage from './view/topoManage';
import HistoricalData from './view/historicalData';
import RecentAlarm from './view/recentAlarm';
import AlarmManage from './view/alarmManage';
import CreateEquipment from './view/createEquipment';
import PLCManager from './view/plcManager';
import IECClient from './view/iec/client';
import IECServer from './view/iec/server';

import './styles/giot/index.scss';
import "./styles/view/common/index.scss";
import "./styles/view/region/index.scss";

const plugView = {
  alarmManage: AlarmManage, //告警管理路由配置
  deviceInterface: DeviceInterface, //设备接口路由配置
  deviceProtocol: DeviceProtocol, //设备协议路由配置
  deviceManage: DeviceManage, // 设备模板
  ruleManage: RuleManage, //任务管理路由配置
  topoManage: TopoManage, // 拓扑视图
  historicalData: HistoricalData, // 历史数据
  recentAlarm: RecentAlarm, //当前告警路由配置
  createEquipment: CreateEquipment, // 设备列表
  plcManager: PLCManager,
  iec104client: IECClient,
  iec104server: IECServer
};

export default plugView;