import actionCreator from 'amos-processor/lib/redux/actionCreator';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
// import completeSecurityUrl from 'amos-security/lib/consts/securityUrl';

export const COMPANY_TABLE_INFOS = 'COMPANY_TABLE_INFOS'; //公司-单位管理表格信息
export const COMPANY_TABLE_INFOS_SUCCESS = 'COMPANY_TABLE_INFOS_SUCCESS'; //公司-单位管理表格信息
export const COMPANY_TABLE_INFOS_ERROR = 'COMPANY_TABLE_INFOS_ERROR'; //公司-单位管理表格信息

export const COMPANY_LEVELS = 'COMPANY_LEVELS'; //公司-获取单位级别集合
export const COMPANY_LEVELS_SUCCESS = 'COMPANY_LEVELS_SUCCESS'; //公司-获取单位级别集合
export const COMPANY_LEVELS_ERROR = 'COMPANY_LEVELS_ERROR'; //公司-获取单位级别集合

export const COMPANY_DEL = 'COMPANY_DEL'; //公司-删除单位信息
export const COMPANY_DEL_SUCCESS = 'COMPANY_DEL_SUCCESS'; //公司-删除单位信息
export const COMPANY_DEL_ERROR = 'COMPANY_DEL_ERROR'; //公司-删除单位信息

export const COMPANY_ADD = 'COMPANY_ADD'; //公司-添加单位信息
export const COMPANY_ADD_SUCCESS = 'COMPANY_ADD_SUCCESS'; //公司-添加单位信息
export const COMPANY_ADD_ERROR = 'COMPANY_ADD_ERROR'; //公司-添加单位信息

export const COMPANY_EDIT = 'COMPANY_EDIT'; //公司-编辑单位信息
export const COMPANY_EDIT_SUCCESS = 'COMPANY_EDIT_SUCCESS'; //公司-编辑单位信息
export const COMPANY_EDIT_ERROR = 'COMPANY_EDIT_ERROR'; //公司-编辑单位信息

export const COMPANY_INFO = 'COMPANY_INFO'; //公司-根据id获取单位信息
export const COMPANY_INFO_SUCCESS = 'COMPANY_INFO_SUCCESS'; //公司-根据id获取单位信息
export const COMPANY_INFO_ERROR = 'COMPANY_INFO_ERROR'; //公司-根据id获取单位信息

export const COMPANY_ALL_LIST = 'COMPANY_ALL_LIST'; //公司-所有单位信息
export const COMPANY_ALL_LIST_SUCCESS = 'COMPANY_ALL_LIST_SUCCESS'; //公司-所有单位信息
export const COMPANY_ALL_LIST_ERROR = 'COMPANY_ALL_LIST_ERROR'; //公司-所有单位信息

export const COMPANY_SUPERIOR_LIST = 'COMPANY_SUPERIOR_LIST'; //公司-获取所有上级单位集合
export const COMPANY_SUPERIOR_LIST_SUCCESS = 'COMPANY_SUPERIOR_LIST_SUCCESS'; //公司-获取所有上级单位集合
export const COMPANY_SUPERIOR_LIST_ERROR = 'COMPANY_SUPERIOR_LIST_ERROR'; //公司-获取所有上级单位集合

export const COMPANY_EIDT_SPERIOR_LIST = 'COMPANY_EIDT_SPERIOR_LIST'; //公司-编辑时获取上级单位集合
export const COMPANY_EIDT_SPERIOR_LIST_SUCCESS = 'COMPANY_EIDT_SPERIOR_LIST_SUCCESS'; //公司-编辑时获取上级单位集合
export const COMPANY_EIDT_SPERIOR_LIST_ERROR = 'COMPANY_EIDT_SPERIOR_LIST_ERROR'; //公司-编辑时获取上级单位集合


export default function(base) {
  let sysUrl = completeSecurityUrl(base);
  return {
    /**
     * 公司-获取单位级别集合
     * @param {string} companyLevels
     */
    companyLevelsAction: () => actionCreator({
      type: COMPANY_LEVELS,
      method: 'get',
      url: sysUrl.companyLevels
    }),
    /**
     * 公司-单位管理表格信息
     * @param {string} companyInfos
     */
    companyTableAction: () => actionCreator({
      type: COMPANY_TABLE_INFOS,
      method: 'get',
      url: sysUrl.companyInfos
    }),

    /**
     * 公司-获取所有上级单位集合
     * @param {string} companyInfos
     *
     */
    superiorUnitAction: () => actionCreator({
      type: COMPANY_SUPERIOR_LIST,
      method: 'get',
      url: sysUrl.superiorUnitUrl
    }),
    /**
     * 公司-编辑时获取上级单位集合
     * @param {string} superiorUnitEditUrl
     * @param {string} id
     *
     */
    superiorUnitEditAction: (id) => actionCreator({
      type: COMPANY_EIDT_SPERIOR_LIST,
      method: 'get',
      url: formatUrl(sysUrl.superiorUnitEditUrl, { id })
    }),
    /**
     * 公司-根据id获取单位信息
     * @param {string} getCompanyById
     * @param {string} id
     *
     */
    companyInfoAction: (id) => actionCreator({
      type: COMPANY_INFO,
      method: 'get',
      url: formatUrl(sysUrl.getCompanyById, { id })
    }),
    /**
     * 公司-删除单位信息
     */
    companyDelAction: (id) => actionCreator({
      type: COMPANY_DEL,
      method: 'del',
      url: `${sysUrl.delCompany}?ids=${id}`
    }),
    /**
     * 公司-添加单位信息
     */
    companyAddAction: (obj) => actionCreator({
      type: COMPANY_ADD,
      method: 'put',
      url: sysUrl.addCompany,
      data: obj
    }),
    /**
     * 公司-编辑单位信息
     */
    companyEditAction: (obj) => actionCreator({
      type: COMPANY_EDIT,
      method: 'put',
      url: sysUrl.editCompany,
      data: obj
    })
  };
}
