import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Icon } from 'amos-antd';
// import './style/gridBtn.scss';

/**
 * 表格操作按钮
 * @class GridButton
 * @extends {Component}
 */
class GridButton extends Component {
  constructor(props) {
    super(props);

  }

  render() {
    const { text, onClick, icon, className } = this.props;
    return (
      <a className={className} title={text} onClick={onClick} >
        <Icon type={icon} />
        <span>{text}</span>
      </a>
    );
  }
}

GridButton.propTypes = {
  text: PropTypes.string,
  onClick: PropTypes.func,
  icon: PropTypes.string,
  className: PropTypes.string
};

GridButton.defaultProps = {
  className: 'amos-grid-btn'
};

export default GridButton;
