import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosFetch } from '../utils/processor';
import OltSerUrl from '../../../consts/urlConsts';
/**
 * 协议筛选
 *
 * @class ProtocolOptionsFilter
 * @extends {Component}
 */
class ProtocolOptionsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      protocolOptions: [],
      clearBtnStyle: 'all-filter-btn selected-btn'
    };
  }

  componentDidMount = () => {
    let { flag } = this.props;
    let visibility = '';
    if (flag === '1'){
      visibility = '0';
    } else if (flag === '2'){
      visibility = '1';
    }
    // let defaultCriterias = [{ name: 'visibility',type: 'EQUAL',value: visibility }];
    AmosFetch.post(OltSerUrl.protocolDataList,{ data: {} }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          let protocolCheckBoxList = [];
          data.dataList.map(e=>{
            protocolCheckBoxList.push({ value: e.id,label: e.name,selected: false,style: 'all-filter-btn' });
          });
          this.setState({ protocolOptions: protocolCheckBoxList });
        }
      }
    });
  }

  //全清
  delFilter = () => {
    let { protocolOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn selected-btn';
    protocolOptions.map(option=>{
      option.selected = false;
      option.style = 'all-filter-btn';
    });
    this.setState({ protocolOptions,clearBtnStyle });
    this.props.protocolSelectFunc([]);
  }

  //筛选条件点击事件
  selectClick = (e) => {
    let filterOptionList = [];
    let { protocolOptions,clearBtnStyle } = this.state;
    protocolOptions.map(option=>{
      if (option.label === e.target.innerText) {
        if (option.selected) {
          option.selected = false;
          option.style = 'all-filter-btn';
        } else {
          option.selected = true;
          option.style = 'all-filter-btn selected-btn';
        }
      }
      if (option.selected) {
        filterOptionList.push(option);
      }
    });
    //‘不限’选项的样式控制
    if (filterOptionList.length === 0) {
      clearBtnStyle = 'all-filter-btn selected-btn';
    } else {
      clearBtnStyle = 'all-filter-btn';
    }
    this.setState({ protocolOptions,clearBtnStyle });
    this.props.protocolSelectFunc(filterOptionList);
  }

  //反选‘不限’
  disableAllSelected = () => {
    let clearBtnStyle = 'all-filter-btn selected-btn';
    this.setState({ clearBtnStyle });
  }

  //加载协议所有筛选按钮
  AllProtocolOptionFunc = () => {
    let { protocolOptions,clearBtnStyle } = this.state;
    let res = [];
    res.push(
      <div key={`protocol0`} className={clearBtnStyle} onClick={this.delFilter}>
        <div>不限</div>
      </div>);
    protocolOptions.map(option=>{
      res.push(<div key={`protocol${option.value}`} className={option.style} onClick={this.selectClick}>{option.label}</div>);
      // if (option.selected) {
      //   clearBtnStyle = 'all-filter-btn selected-btn';
      // }
    });
    return res;
  }

  render() {
    return (
      this.AllProtocolOptionFunc()
    );
  }
}

ProtocolOptionsFilter.propTypes = {
  protocolSelectFunc: PropTypes.func,
  flag: PropTypes.string
};

export default ProtocolOptionsFilter;
