import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'amos-react-router';
import Icon from 'amos-icon';
import { Icon as AFIcon } from 'amos-framework';
import connectMenu from './connectMenu';

/**
 * 级别 menu
 * @class LevelMenu
 * @extends {Component}
 */
@connectMenu
export default class LevelMenu extends Component {

  renderItemLink = (item) => {
    const { iconPrefix } = this.props;
    const { icon, label, isBlank, path, permissionName } = item;
    const NavIcon = icon && <Icon icon={icon} prefix={iconPrefix} className="menu-item-icon" />;
    let Item;
    if (isBlank) {
      Item = (
        <a href={path} target="_blank" rel="noopener noreferrer" className="menu-item-link">
          {NavIcon}
          {permissionName}
        </a>
      );
    } else {
      Item = (
        <Link to={path} className="menu-item-link">
          {NavIcon}
          {permissionName}
        </Link>
      );
    }
    return Item;
  }

  render() {
    const { className, onClick, nonChild, children } = this.props;
    return (
      <li
        className={className}
        onClick={onClick}
      >
        {this.renderItemLink(this.props)}
        {!nonChild && <AFIcon icon="right" className="menu-subitem-icon" />}
        {!nonChild && children}
      </li>
    );
  }
}

LevelMenu.propTypes = {
  nonChild: PropTypes.bool,
  className: PropTypes.string,
  iconPrefix: PropTypes.string,
  onClick: PropTypes.func,
  children: PropTypes.node
};
