import React from 'react';
/**
 * 单位管理表格列模型
 */
export const companyColumns = (companyLevelOptions) => {
  return [{
    title: '单位名称',
    dataIndex: 'companyName',
    query: true,
    required: true,//是否是默认显示的
    primary: true,//是否出现在模糊搜索文本框中
    st: 'text',//搜索的类型
    key: 'companyName',
    width: '30%',
    render: (text,record) => {
      let className = 'tree-td-children';
      if (record.children && record.children.length === 0){
        className = 'tree-td-children-empty';
      }
      return (<span className={className}>{text}</span>);
    }
  }, {
    title: '单位描述',
    dataIndex: 'description',
    key: 'description',
    width: '60%'
  }];
};
