import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PubSub } from 'ray-eventpool';
import InterfaceListPanel from './InterfaceListPanel';
import { CONFIG_PANEL_SHOW_TOPIC } from './../common/ActionConf';
/**
 *
 *
 * @class DeviceCapacityInfo
 * @extends {Component}
 */
class DeviceCapacityInfo extends Component {
  constructor(props){
    super(props);
    this.state = {

    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  openConfigPanel = () => {
    let { onlinTestSwich,intfcList,quotaList,quotaSelected } = this.props;
    PubSub.publish(CONFIG_PANEL_SHOW_TOPIC.trigger, {
      type: 3,
      onlinTestSwich,
      intfcList,
      quotaList,
      quotaSelected
    });
  }

  render() {
    return (
      <div className='add-device-left-capacity'>
        <div className='template-capacity-info-title'>设备能力示意图</div>
        <div className='template-capacity-device'>
          <img src={require('./../../../assets/iot/deviceManage/allin.png')} alt='' />
        </div>
        {/*<div className='template-capacity-line'>
          <img src={require('./../../../assets/iot/deviceManage/usb_line.png')} alt='' />
        </div>
        <div className='template-capacity-port'>
          <img src={require('./../../../assets/iot/deviceManage/usb_port.png')} alt='' />
        </div>
        <div className='template-capacity-status'>
          <img src={require('./../../../assets/iot/deviceManage/link_ok.png')} alt='' />
        </div>
        <div className='template-capacity-empty'>
          <img src={require('./../../../assets/iot/deviceManage/empty.png')} alt='' />
    </div>
        <div className='template-capacity-add'>
          自定义接口
        </div>*/}
        <div className='template-capacity-test' onClick={this.openConfigPanel}>
          测试设备
        </div>
        <InterfaceListPanel {...this.props} />
      </div>
    );
  }
}

DeviceCapacityInfo.propTypes = {
  onlinTestSwich: PropTypes.func,
  intfcList: PropTypes.any,
  quotaList: PropTypes.any,
  quotaSelected: PropTypes.any,
  device: PropTypes.object,
  equipment: PropTypes.object,
  updateInterfaceCellStatus: PropTypes.func,
  enable: PropTypes.bool
};

DeviceCapacityInfo.defaultProps = {
  enable: true
};

export default DeviceCapacityInfo;
