import React, { Component } from 'react';
import PropTypes from 'prop-types';
import InterfaceCommonCell from './commoncell/InterfaceCommonCell';
import { fetchTemplatOrEqpIntfcAction } from './../../../services/deviceService';

/**
 *
 *
 * @class InterfaceListPanel
 * @extends {Component}
 */
class InterfaceListPanel extends Component {
  constructor(props){
    super(props);
    this.state = {
      intfcList: []
    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    let { device,equipment } = this.props;
    this.getTemplatIntfcs(device.id,equipment ? equipment.id : 0);
  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getTemplatIntfcs = (devId,eqpId) => {
    fetchTemplatOrEqpIntfcAction(devId,eqpId).then(data => {
      if (data !== null) {
        this.setState({ intfcList: data });
      }
      this.props.getIntfcInfo(data);
    });
  }

  getInerfaceList = () => {
    let content = [];
    let { intfcList } = this.state;
    intfcList.map(item => {
      content.push(<InterfaceCommonCell key={item.id} content={item} {...this.props} />);
    });
    return content;
  }

  render() {
    return (
      <div className='template-capacity-interface-list-root'>
        <div className='template-capacity-interface-list-title'>设备接口</div>
        <div className='template-capacity-interface-list-content'>
          {this.getInerfaceList()}
        </div>
      </div>
    );
  }
}

InterfaceListPanel.propTypes = {
  device: PropTypes.object,
  updateInterfaceCellStatus: PropTypes.func,
  getIntfcInfo: PropTypes.func,
  equipment: PropTypes.object
};

export default InterfaceListPanel;
