import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input } from 'amos-framework';
import { PubSub } from 'ray-eventpool';
import { EQUIPMENT_BATCH_DELETE_TOPIC } from './../common/ActionConf';

/**
 *
 *
 * @class DeviceListPanelHead
 * @extends {Component}
 */
class DeviceListPanelHead extends Component {
  constructor(props){
    super(props);
    this.state = {
      name: ''
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onBackAction = () => {
    this.props.updateMainView({ flag: '1' });
  }

  onInputChange = (e) => {
    this.setState({ name: e.target.value });
  }

  addDevice = () => {
    this.props.updateMainView({ flag: '2',device: this.props.device,resourceFlag: '3' });
  }

  doSearch = () => {
    this.props.setSearchParam(this.state.name);
  }

  batchDelete = () => {
    PubSub.publish(EQUIPMENT_BATCH_DELETE_TOPIC.trigger, {

    });
  }

  render() {
    return (
      <div className='device-list-panel-head-root'>
        {/*<div className='device-list-panel-head-help'>
          <img src={require('./../../../assets/iot/deviceManage/help.png')} alt='' />
    </div>*/}
        <div className='device-list-panel-head-back' onClick={this.onBackAction}>
          <img src={require('./../../../assets/iot/deviceManage/back.png')} alt='' />
        </div>
        <div className='device-list-panel-head-delete'>
          <img src={require('./../../../assets/iot/deviceManage/delete.png')} onClick={this.batchDelete} alt='' />
        </div>
        <div className='device-list-panel-head-add'>
          <img src={require('./../../../assets/iot/deviceManage/add_small.png')} onClick={this.addDevice} alt='' />
        </div>
        <div className='device-list-panel-head-search'>
          <img src={require('./../../../assets/iot/deviceManage/search.png')} onClick={this.doSearch} alt='' />
          <Input placeholder="请输入" className='device-list-panel-head-input' onChange={(e) => this.onInputChange(e)} />
        </div>
      </div>
    );
  }
}

DeviceListPanelHead.propTypes = {
  updateMainView: PropTypes.func,
  device: PropTypes.object,
  deleteDeviceById: PropTypes.func,
  setSearchParam: PropTypes.func
};

export default DeviceListPanelHead;
