import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button } from 'amos-antd';
import { Editable,message } from 'amos-framework';
import { editEquipmentNameAction } from './../../../../services/deviceService';

/**
 *
 *
 * @class TemplateDetail
 * @extends {Component}
 */
class TemplateDetail extends Component {
  constructor(props){
    super(props);
    this.state = {
      visible: false,
      deviceName: {}
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  /**
   * 打开对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  onTextChange =  (key,e) => {
    let { deviceName } = this.state;
    deviceName[key] = e;
    this.setState({ deviceName });
  }

  confirmEdit = () => {
    let { deviceName } = this.state;
    editEquipmentNameAction(deviceName).then(data => {
      message.success('编辑成功');
      this.handCancel();
    });
  }

  /**
   * 关闭对话框
   */
  handCancel = () => {
    this.setState({ visible: false });
  }

  render() {
    let { record } = this.props;
    return (
      <div  className='template-detail-root'>
        <Button size='small' style={{ marginLeft: '10px' }} onClick={this.onClick} >详情</Button>
        <Modal maskClosable={false} title='设备详情' closable visible={this.state.visible} onOk={this.confirmEdit} onCancel={this.handCancel} width={500} footer={null} >
          <div>
            <div>设备名称：{record.name}</div>
            <div>设备描述：{record.descr}</div>
          </div>
        </Modal>
      </div>
    );
  }
}

TemplateDetail.propTypes = {
  record: PropTypes.object
};

export default TemplateDetail;
