import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button } from 'amos-antd';
import { Editable,message,Row,Col } from 'amos-framework';
import { editEquipmentNameAction } from './../../../../services/deviceService';

/**
 *
 *
 * @class TemplateEdit
 * @extends {Component}
 */
class TemplateEdit extends Component {
  constructor(props){
    super(props);
    this.state = {
      visible: false,
      deviceName: {}
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  /**
   * 打开对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  onTextChange =  (key,e) => {
    let { deviceName } = this.state;
    let { record } = this.props;
    deviceName[key] = e;
    deviceName.id = record.id;
    this.setState({ deviceName });
  }

  confirmEdit = () => {
    let { deviceName } = this.state;
    editEquipmentNameAction(deviceName).then(data => {
      message.success('保存成功');
      this.handCancel();
      this.props.reload();
    });
  }

  /**
   * 关闭对话框
   */
  handCancel = () => {
    this.setState({ visible: false });
  }

  render() {
    let { record } = this.props;
    return (
      <div className='template-edit-root'>
        <Button size='small' style={{ marginLeft: '10px' }} onClick={this.onClick} >编辑</Button>
        <Modal maskClosable={false} title='编辑设备' closable visible={this.state.visible} onOk={this.confirmEdit} onCancel={this.handCancel} width={500} >
          <Row className='template-edit-name-root'>
            <Col span={4} offset={0} className='template-edit-name'>设备名称：</Col>
            <Col span={9} offset={0} className='template-edit-name-value'>
              <Editable defaultValue={record.name} onChange={(e) => this.onTextChange('name', e)} showOkCancel={false} />
            </Col>
          </Row>
          <Row  className='template-edit-descr-root'>
            <Col span={4} offset={0} className='template-edit-descr'>设备描述：</Col>
            <Col span={9} offset={0} className='template-edit-descr-value'>
              <Editable defaultValue={record.descr} onChange={(e) => this.onTextChange('desc', e)} showOkCancel={false} />
            </Col>
          </Row>
        </Modal>
      </div>
    );
  }
}


TemplateEdit.propTypes = {
  record: PropTypes.object,
  reload: PropTypes.func
};


export default TemplateEdit;
