import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select,Input } from 'amos-antd';
// import { Input } from 'amos-framework';
import OltSerUrl from '../../../consts/urlConsts';
import { AmosFetch } from '../../../utils/processor';
import { deviceCategoryEnum } from  './../../deviceManage/common/DeviceEnum';
import { enums2array } from './../../deviceManage/common/DeviceLang';

const Option = Select.Option;

const dataTypeOption = enums2array(deviceCategoryEnum).map((item)=>
  <Option key={item.key} value={`${item.key}`}>{item.label}</Option>) ;
/**
 *
 *
 * @class CreateDeviceSearch
 * @extends {Component}
 */
class CreateDeviceSearch extends Component {
  constructor(props){
    super(props);
    this.state = {
      equiptemplateIndustryOptions: [],
      searchParam: {},
      modelOptions:[]
    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    this.getVocationData();
  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onChange = (e) => {
    let { searchParam } = this.state;
    searchParam['name'] = e.target.value;
    this.setState({ searchParam });
  }

  onSelectedChange = (value,type) => {
    let { searchParam } = this.state;
    searchParam[type] = value;
    this.setState({ searchParam });
  }

  getVocationData = () => {
    //获取行业
    AmosFetch.get(OltSerUrl.equiptemplateIndustry).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let equiptemplateIndustryDataList = [];
        data ? data.dataList.map(e=>{
          equiptemplateIndustryDataList.push(
            <Option key={e.id} value={`${e.id}`}>{e.name}</Option>);
        }) : [];
        this.setState({ equiptemplateIndustryOptions: equiptemplateIndustryDataList });
      }
    });
    //获取设备型号
    AmosFetch.get(OltSerUrl.getDeviceModeData).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let modelDataList = [];
        data ? data.dataList.map(e=>{
          modelDataList.push(
            <Option key={e.model} value={`${e.model}`}>{e.model}</Option>);
        }) : [];
        this.setState({ modelOptions: modelDataList });
      }
    });
  }

  searchData = () => {
    let { searchParam } = this.state;
    searchParam && this.props.setSearchParam(searchParam);
  }

  render() {
    let { equiptemplateIndustryOptions,modelOptions} = this.state;
    return (
      <div className='create-device-search-root'>
        <div className='create-device-search-tab'>我的设备</div>
        <div className='catalog-select'>
          <Select
            style={{ width: '170px' }}
            dropdownStyle={{ width: '170px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'type')}
            placeholder='类别'
            allowClear
          >
            {dataTypeOption}
          </Select>
        </div>
        <div className='vocation-select'>
          <Select
            style={{ width: '170px' }}
            dropdownStyle={{ width: '170px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'industryId')}
            placeholder='行业'
            allowClear
          >
            {equiptemplateIndustryOptions}
          </Select>
        </div>
        <div className='vocation3-select'>
          <Select
            style={{ width: '170px' }}
            dropdownStyle={{ width: '170px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'model')}
            placeholder='型号'
            allowClear
          >
             {modelOptions} 
          </Select>
        </div>
        <div className='search-device'>
          <Input placeholder="请输入搜索内容" onChange={this.onChange} onPressEnter={this.searchData} style={{ width: '150px','border-radius': '10px' }} />
          <img src={require('./../../../assets/iot/deviceManage/search.png')} alt='' onClick={this.searchData} />
        </div>
      </div>
    );
  }
}

CreateDeviceSearch.propTypes = {
  setSearchParam: PropTypes.func
};

export default CreateDeviceSearch;
