import React, { Component } from 'react';
//import PropTypes from 'prop-types';
import { Tabs } from 'amos-antd';
import { AmosFetch } from '../../utils/processor';
import OltSerUrl from '../../consts/urlConsts';
import PublicInterface from './publicInterface';
import PrivateInterface from './privateInterface';
import AddInterface from './addInterface';
import PrivateInterfaceDetail from './privateInterface/PrivateInterfaceDetail';
import SearchBar from './common/searchBar';
import './../common/style/commonTabs.scss';
import './../common/style/commonStyle.scss';
import PropTypes from 'amos-react-router/lib/PropTypes';

const TabPane = Tabs.TabPane;

/**
 * 设备接口管理
 *
 * @class DeviceInterface
 * @extends {Component}
 */
class DeviceInterface extends Component {
  constructor(props) {
    super(props);
    let activeKey = '1';
    const newLocal = this.props.location;
    if (newLocal.query.activeKey){
      activeKey = newLocal.query.activeKey;
    }
    this.state = {
      // 当前选中的界面，0 公共接口 1 私有接口，默认为'0'
      visibility: '0',
      // 查询条件list，默认为空
      criterias: [],
      // 选中界面的标记
      flag: activeKey,
      //接口数据集合
      dataList: [],
      //下拉框数据集合
      communityDatas: [],
      communityOptions: [],
      tabContent: [],
      privateTabContent: [],
      activeKey
    };
  }

  componentWillMount(){
    //获取接口通讯方式
    AmosFetch.get(OltSerUrl.communityProtocol).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let communityDataList = [];
        data ? data.dataList.map(e=>{
          communityDataList.push({ value: e.id,label: e.name,selected: false,style: 'all-filter-btn' });
        }) : [];
        this.setState({ communityOptions: communityDataList,communityDatas: data.dataList });
      }
    });
    this.requestMethod(this.state.activeKey === '1' ? '0' : '1',[]);
  }

  onTabClick = (value) =>{
    if ( value === '1'){
      this.requestMethod('0',this.state.criterias,undefined,value);
    } else if (value === '2'){
      this.requestMethod('1',this.state.criterias,undefined,value);
    }
  }

   /**
   * 查询条件封装，向后端发起请求获取结果
   * @param {string} visibility 目前所处页面属于私有或者公有
   * @param {list} criterias 查询条件
   * @param {list} carInfoData 原卡片数据集合
   * @param {string} value 查询私有还是公有数据
   */
  requestMethod = (visibility, criterias,carInfoData,value) => {
    let defaultCriterias = { name: 'visibility',type: 'EQUAL',value: visibility };
    let newCriterias = [];
    if (criterias.length > 0){
      for (let i = 0; i < criterias.length; i++) {
        let data = criterias[i];
        if (data.type !== 'EQUAL'){
          newCriterias.push(data);
        }
      }
      criterias = newCriterias;
    }
    criterias.push(defaultCriterias);
    AmosFetch.post(OltSerUrl.interfaceDataList,{ data: criterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          this.setState({ dataList: data.dataList });
        }
      } else {
        this.setState({ dataList: [] });
      }
      //
      if (carInfoData) {
        this.setState({ carInfo: carInfoData });
      }
      if (value) {
        this.setState({
          flag: value,
          criterias: [],
          visibility,
          activeKey: value
        });
      }
      let { communityDatas,criterias } = this.state;
      let tabContent = [];
      let privateTabContent = [];
      let activeKey = this.state.activeKey;
      if (activeKey === '1'){
        tabContent.push(<PublicInterface key={1} updateAddView={this.updateAddView} dataList={data.dataList} requestMethod={this.requestMethod} criterias={criterias} visibility='0' />);
        this.setState({
          tabContent
        });
      } else if (activeKey === '2') {
        privateTabContent.push(<PrivateInterface key={2} communityDatas={communityDatas} updateAddView={this.updateAddView} dataList={data.dataList} requestMethod={this.requestMethod} criterias={criterias} visibility='1' />);
        this.setState({
          privateTabContent
        });
      }
    });
  }

  /**
   * 子页面回调函数方法，更改界面标记
   * @param {string} flag 界面标记 1 公共界面 2 私有界面
   * @param {list} carInfo 当前界面的数据集合
   */
  updateAddView=(flag,carInfo)=>{
    if (flag === '2'){
      this.requestMethod(this.state.visibility,this.state.criterias,carInfo);
    }  else {
      let activeKey = this.state.activeKey;
      if (activeKey === '1'){
        this.setState({ flag,carInfo,tabContent: this.showTabPane(flag,carInfo) });
      } else if (activeKey === '2') {
        this.setState({ flag,carInfo,privateTabContent: this.showTabPane(flag,carInfo) });
      }
    }
  }

  showTabPane = (flag,carInfo) => {
    let { communityDatas,criterias } = this.state;
    let res = [];
    switch (flag) {
      case '1': //公共接口界面
        res.push(<PublicInterface key={1} updateAddView={this.updateAddView} dataList={this.state.dataList} requestMethod={this.requestMethod} criterias={criterias} visibility='0' />);
        break;
      case '2': //私有接口界面
        res.push(<PrivateInterface key={2} communityDatas={communityDatas} updateAddView={this.updateAddView} dataList={this.state.dataList} requestMethod={this.requestMethod} criterias={criterias} visibility='1' />);
        break;
      case '3': //接口详情界面
        res.push(<PrivateInterfaceDetail key={3} communityDatas={communityDatas} carInfo={carInfo} />);
        break;
      case '4': //接口新增界面
        res.push(<AddInterface key={4} communityDatas={communityDatas} updateAddView={this.updateAddView} />);
        break;
      default:res.push(<PublicInterface key={1} updateAddView={this.updateAddView} criterias={criterias} visibility='0' />);
        break;
    }
    return res;
  }

  handleCriterias=(criterias)=>{
    let { visibility } = this.state;
    this.setState({ criterias });
    this.requestMethod(visibility,criterias);
  }

  render() {
    let { communityOptions,activeKey,privateTabContent,tabContent } = this.state;
    return (
      <div className='tabs-outside'>
        <Tabs
          activeKey={activeKey}
          onTabClick={this.onTabClick}
          tabBarExtraContent={<SearchBar handleCriterias={this.handleCriterias} communityOptions={communityOptions} />}
        >
          <TabPane tab={<div>公共</div>} key="1">
            {tabContent}
          </TabPane>
          <TabPane tab={<div>我的</div>} key="2">
            {privateTabContent}
          </TabPane>
        </Tabs>
      </div>
    );
  }
}

DeviceInterface.propTypes = {

};

export default DeviceInterface;
