import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Form } from 'amos-antd';
import AddEditInterfaceProperty from './AddEditInterfaceProperty';
import './interface-detail.scss';

const createForm = Form.create();
/**
 * 编辑属性
 */
class EditInterfaceProperty extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,requestIntfcAttrs,propertyInfo } = this.props;
    return (
      <div className='interface-detail-property-button' onClick={this.onClick}>
        <img src={require('./../../../assets/iot/img/mk_edit.png')} alt='' />
        <Modal maskClosable={false} title='编辑属性' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditInterfaceProperty propertyInfo={propertyInfo} requestIntfcAttrs={requestIntfcAttrs} form={form} callBack={this.handCancel} />
        </Modal>
      </div>
    );
  }
}

EditInterfaceProperty.propTypes = {
  form: PropTypes.any
};

export default createForm(EditInterfaceProperty);
