import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card,Icon,Modal } from 'amos-antd';
import { message } from 'amos-framework';
import { AmosFetch } from '../../../utils/processor';
import { OltSerUrl } from '../../../consts/urlConsts';
import { completeDevIcon } from '../../../consts/viewConsts';
import { deviceCategoryEnum } from  './../common/DeviceEnum';
import { stringUtil } from './../common/DeviceLang';
import './deviceCard.scss';

/**
 * 表格展示的卡片元素
 *
 * @class TableCard
 * @extends {Component}
 */
class TableCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  confirm = () => {
    let { cardData,updateAddView } = this.props;
    //删除数据库
    let url = `${OltSerUrl.deleteDeviceById}/${cardData.id}`;
    AmosFetch.del(url).then(res => {
      if (res.ok) {
        return res.text();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
    //重新刷新数据
      message.success('删除成功！');
      //更新card
      updateAddView('2');
    });
  }

  delBtn = () => {
    Modal.confirm({
      title: '删除',
      content: '是否删除所选信息？',
      okText: '确定',
      cancelText: '取消',
      onOk: this.confirm,
      onCancel() {}
    });
  };

  //显示详情页面
  showDetail = () => {
    let { updateAddView,cardData } = this.props;
    updateAddView('3',cardData);
  }

  //标题额外按钮
  extraBtn = () => {
    const { isDel, cardData = {} } = this.props;
    const extraIcon = completeDevIcon(cardData.typeImg);
    let res = [];
    res.push(<div key={`left0`} className='title-left'><img src={extraIcon}  alt="" /></div>);
    if (isDel) {
      res.push(<a key={`del0`} onClick={this.delBtn} ><Icon type='close' className='basic-info-add' /></a>);
    } else {
      res.push(<div key={`block0`} style={{ width: '12px',display: 'inline-block' }} />);
    }
    return res;
  }


  render() {
    let { cardData } = this.props;
    let displayImgUrl = cardData.img;
    let srcImgUrl = displayImgUrl === '' ? `${OltSerUrl.fetchDeviceImg}/default.png` : `${OltSerUrl.fetchDeviceImg}/${displayImgUrl}`;
    let name = cardData ? cardData.name : '';
    let type = cardData ? stringUtil(deviceCategoryEnum,parseInt(cardData.type)) : '';
    let model = cardData ? cardData.model : '';
    let industryName = cardData ? cardData.industryName:'';
    return (
      <div className='table-card '>
        <Card title={name} extra={this.extraBtn()}>
          <a onClick={this.showDetail} >
            <div className='allspace'>
              <div className='card-info'>
                <img src={srcImgUrl} alt='device' />
              </div>
              <div className='card-info'>
                <p title={model} >型号：{model}</p>
                <p title={type} >类别：{type}</p>
                <p title={industryName} >所属行业：{industryName}</p>
              </div>
            </div>
          </a>
        </Card>
      </div>
    );
  }
}

TableCard.propTypes = {
  cardData: PropTypes.any,
  isDel: PropTypes.bool,
  updateAddView: PropTypes.func,
  requestMethod: PropTypes.func
};

export default TableCard;
