import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card } from 'amos-antd';
import Icon from 'amos-icon';

/**
 * 表格展示的卡片元素
 *
 * @class TableCard
 * @extends {Component}
 */
class TableCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  onClick = () => {
    this.props.updateAddView('4');
  }

  render() {
    return (
      <div className='table-card'>
        <Card bodyStyle={{ textAlign: 'center' }} title='新建通信协议' >
          <div className='index-add-img' onClick={this.onClick} >
            <Icon className="protocol-lib-icon" icon="add" />
          </div>
        </Card>
      </div>
    );
  }
}

TableCard.propTypes = {
  cardData: PropTypes.any,
  updateAddView: PropTypes.func
};

export default TableCard;
