import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Icon,Row,Col } from 'amos-antd';
import ComMethodOptionsFilter from './../../common/filterOptions/comMethodOptionFilter';

/**
 * 筛选按钮
 *
 * @class FilterBtn
 * @extends {Component}
 */
class FilterBtn extends Component {
  constructor(props) {
    super(props);
    this.state = {
      comMethodSelectedOption: []
    };
  }

  comMethodSelectFunc = (values) => {
    this.setState({ comMethodSelectedOption: values });
    this.props.filterOnChange(values);
  }

  //单个删除筛选条件
  delBtn = (value) => {
    let { comMethodSelectedOption } = this.state;
    let filterList = [];
    comMethodSelectedOption.map(option=>{
      if (option.label === value) {
        option.selected = false;
        option.style = 'all-filter-btn';
      }
      if (option.selected) {
        filterList.push(option);
      }
    });
    this.props.filterOnChange(filterList);
    this.setState({ comMethodSelectedOption });
  }

  //加载已选择的条件
  SelectOptions = () => {
    let { comMethodSelectedOption } = this.state;
    let res = [];
    comMethodSelectedOption.map(option=>{
      if (option.selected) {
        res.push(
          <div key={`option${option.value}`} id={option.value} onClick={() => this.delBtn(option.label)} className='select-filter-btn'>
            {option.label}<Icon type='close' />
          </div>);
      }
    });
    return res;
  }

  render() {
    return (
      <div>
        <Row>
          <Col span={8}>
            <span>筛选条件：</span>
          </Col>
          <Col span={16}>
            {this.SelectOptions()}
          </Col>
        </Row>
        <Row>
          <Col span={8}>
            <span>实现方式：</span>
          </Col>
          <Col span={16}>
            <ComMethodOptionsFilter comMethodSelectFunc={this.comMethodSelectFunc} {...this.props} />
          </Col>
        </Row>
      </div>
    );
  }
}

FilterBtn.propTypes = {
  filterOnChange: PropTypes.func,
  scriptLangOptions: PropTypes.array
};

export default FilterBtn;
